/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;

public class LinguisticsManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.m_20148_());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.m_20148_());
        }
    }

    public static int getComprehension(@Nullable Player player, @Nullable BookLanguage language) {
        MutableInt retVal = new MutableInt(0);
        if (player != null && language != null) {
            PrimalMagickCapabilities.getLinguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getComprehension(language.languageId())));
        }
        return retVal.intValue();
    }

    public static void setComprehension(@Nullable Player player, @Nullable BookLanguage language, int comprehension) {
        if (player != null && language != null) {
            PrimalMagickCapabilities.getLinguistics(player).ifPresent(linguistics -> {
                linguistics.setComprehension(language.languageId(), Mth.m_14045_((int)comprehension, (int)0, (int)language.complexity()));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static void incrementComprehension(@Nullable Player player, @Nullable BookLanguage language) {
        LinguisticsManager.incrementComprehension(player, language, 1);
    }

    public static void incrementComprehension(@Nullable Player player, @Nullable BookLanguage language, int delta) {
        if (player != null && language != null) {
            PrimalMagickCapabilities.getLinguistics(player).ifPresent(linguistics -> {
                linguistics.setComprehension(language.languageId(), Mth.m_14045_((int)(linguistics.getComprehension(language.languageId()) + delta), (int)0, (int)language.complexity()));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }
}

