/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncAttunementsPacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerAttunements
implements IPlayerAttunements {
    private final Map<Source, Map<AttunementType, Integer>> attunements = new ConcurrentHashMap<Source, Map<AttunementType, Integer>>();
    private final Set<Source> suppressions = ConcurrentHashMap.newKeySet();
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag attunementList = new ListTag();
        for (Map.Entry<Source, Map<AttunementType, Integer>> sourceEntry : this.attunements.entrySet()) {
            if (sourceEntry == null) continue;
            for (Map.Entry<AttunementType, Integer> typeEntry : sourceEntry.getValue().entrySet()) {
                if (typeEntry == null || sourceEntry.getKey() == null || typeEntry.getKey() == null || typeEntry.getValue() == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Source", sourceEntry.getKey().getTag());
                tag.m_128359_("Type", typeEntry.getKey().name());
                tag.m_128405_("Value", typeEntry.getValue().intValue());
                attunementList.add((Object)tag);
            }
        }
        rootTag.m_128365_("Attunements", (Tag)attunementList);
        ListTag suppressionList = new ListTag();
        for (Source source : this.suppressions) {
            if (source == null) continue;
            suppressionList.add((Object)StringTag.m_129297_((String)source.getTag()));
        }
        rootTag.m_128365_("Suppressions", (Tag)suppressionList);
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Source source;
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clear();
        ListTag attunementList = nbt.m_128437_("Attunements", 10);
        for (int index = 0; index < attunementList.size(); ++index) {
            CompoundTag tag = attunementList.m_128728_(index);
            source = Source.getSource(tag.m_128461_("Source"));
            AttunementType type = null;
            try {
                type = AttunementType.valueOf(tag.m_128461_("Type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int value = tag.m_128451_("Value");
            this.setValue(source, type, value);
        }
        ListTag suppressionList = nbt.m_128437_("Suppressions", 8);
        for (int index = 0; index < suppressionList.size(); ++index) {
            source = Source.getSource(suppressionList.m_128778_(index));
            this.setSuppressed(source, true);
        }
    }

    @Override
    public void clear() {
        this.attunements.clear();
        this.suppressions.clear();
    }

    @Override
    public int getValue(Source source, AttunementType type) {
        return this.attunements.getOrDefault(source, Collections.emptyMap()).getOrDefault((Object)type, 0);
    }

    @Override
    public void setValue(Source source, AttunementType type, int value) {
        if (source != null && type != null) {
            Map typeMap = this.attunements.computeIfAbsent(source, k -> new ConcurrentHashMap());
            int toSet = type.isCapped() ? Mth.m_14045_((int)value, (int)0, (int)type.getMaximum()) : Math.max(0, value);
            typeMap.put(type, toSet);
        }
    }

    @Override
    public boolean isSuppressed(Source source) {
        return this.suppressions.contains(source);
    }

    @Override
    public void setSuppressed(Source source, boolean value) {
        if (source != null) {
            boolean present = this.isSuppressed(source);
            if (!present && value) {
                this.suppressions.add(source);
            } else if (present && !value) {
                this.suppressions.remove(source);
            }
        }
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncAttunementsPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_attunements");
        private final IPlayerAttunements instance = new PlayerAttunements();
        private final LazyOptional<IPlayerAttunements> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.ATTUNEMENTS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

