/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncCompanionsPacket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCompanions
implements IPlayerCompanions {
    private final Map<IPlayerCompanions.CompanionType, LinkedList<UUID>> companions = new ConcurrentHashMap<IPlayerCompanions.CompanionType, LinkedList<UUID>>();
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        for (IPlayerCompanions.CompanionType type : IPlayerCompanions.CompanionType.values()) {
            ListTag list = new ListTag();
            List<UUID> companions = this.get(type);
            for (UUID id : companions) {
                CompoundTag companionTag = new CompoundTag();
                companionTag.m_128362_("Id", id);
                list.add((Object)companionTag);
            }
            rootTag.m_128365_(type.m_7912_(), (Tag)list);
        }
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clear();
        for (IPlayerCompanions.CompanionType type : IPlayerCompanions.CompanionType.values()) {
            if (!nbt.m_128425_(type.m_7912_(), 9)) continue;
            ListTag list = nbt.m_128437_(type.m_7912_(), 10);
            for (int index = 0; index < list.size(); ++index) {
                CompoundTag companionTag = list.m_128728_(index);
                if (!companionTag.m_128403_("Id")) continue;
                this.companions.computeIfAbsent(type, t -> new LinkedList()).add(companionTag.m_128342_("Id"));
            }
        }
    }

    @Override
    public UUID add(IPlayerCompanions.CompanionType type, UUID id) {
        LinkedList list = this.companions.computeIfAbsent(type, t -> new LinkedList());
        if (list.contains(id)) {
            return null;
        }
        list.add(id);
        if (list.size() > type.getLimit()) {
            return (UUID)list.pollFirst();
        }
        return null;
    }

    @Override
    public boolean contains(IPlayerCompanions.CompanionType type, UUID id) {
        return this.companions.getOrDefault((Object)type, new LinkedList()).contains(id);
    }

    @Override
    public List<UUID> get(IPlayerCompanions.CompanionType type) {
        return Collections.unmodifiableList(this.companions.getOrDefault((Object)type, new LinkedList()));
    }

    @Override
    public boolean remove(IPlayerCompanions.CompanionType type, UUID id) {
        return this.companions.getOrDefault((Object)type, new LinkedList()).remove(id);
    }

    @Override
    public void clear() {
        this.companions.clear();
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncCompanionsPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_companions");
        private final IPlayerCompanions instance = new PlayerCompanions();
        private final LazyOptional<IPlayerCompanions> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.COMPANIONS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

