/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncCooldownsPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCooldowns
implements IPlayerCooldowns {
    private final Map<IPlayerCooldowns.CooldownType, Long> cooldowns = new ConcurrentHashMap<IPlayerCooldowns.CooldownType, Long>();
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag cooldownList = new ListTag();
        for (IPlayerCooldowns.CooldownType type : this.cooldowns.keySet()) {
            Long time;
            if (type == null || (time = this.cooldowns.get((Object)type)) == null || time <= 0L) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Type", type.name());
            tag.m_128356_("Value", time.longValue());
            cooldownList.add((Object)tag);
        }
        rootTag.m_128365_("Cooldowns", (Tag)cooldownList);
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clearCooldowns();
        ListTag cooldownList = nbt.m_128437_("Cooldowns", 10);
        for (int index = 0; index < cooldownList.size(); ++index) {
            CompoundTag tag = cooldownList.m_128728_(index);
            IPlayerCooldowns.CooldownType type = null;
            try {
                type = IPlayerCooldowns.CooldownType.valueOf(tag.m_128461_("Type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            long time = tag.m_128454_("Value");
            if (type == null) continue;
            this.cooldowns.put(type, time);
        }
    }

    @Override
    public boolean isOnCooldown(IPlayerCooldowns.CooldownType type) {
        if (type == null) {
            return false;
        }
        return this.cooldowns.getOrDefault((Object)type, 0L) > System.currentTimeMillis();
    }

    @Override
    public long getRemainingCooldown(IPlayerCooldowns.CooldownType type) {
        return Math.max(0L, this.cooldowns.getOrDefault((Object)type, 0L) - System.currentTimeMillis());
    }

    @Override
    public void setCooldown(IPlayerCooldowns.CooldownType type, int durationTicks) {
        if (type != null) {
            this.cooldowns.put(type, System.currentTimeMillis() + (long)(durationTicks * 50));
        }
    }

    @Override
    public void clearCooldowns() {
        this.cooldowns.clear();
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncCooldownsPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_cooldowns");
        private final IPlayerCooldowns instance = new PlayerCooldowns();
        private final LazyOptional<IPlayerCooldowns> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.COOLDOWNS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

