/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncKnowledgePacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.MainIndexResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicFactory;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerKnowledge
implements IPlayerKnowledge {
    private final Set<String> research = ConcurrentHashMap.newKeySet();
    private final Map<String, Integer> stages = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Set<IPlayerKnowledge.ResearchFlag>> flags = new ConcurrentHashMap<String, Set<IPlayerKnowledge.ResearchFlag>>();
    private final Map<KnowledgeType, Integer> knowledge = new ConcurrentHashMap<KnowledgeType, Integer>();
    private final LinkedList<AbstractResearchTopic> topicHistory = new LinkedList();
    private Project project = null;
    private AbstractResearchTopic topic = null;
    private long syncTimestamp = 0L;

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag researchList = new ListTag();
        for (String string : this.research) {
            String str;
            Set<IPlayerKnowledge.ResearchFlag> researchFlags;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("key", string);
            if (this.stages.containsKey(string)) {
                tag.m_128405_("stage", this.stages.get(string).intValue());
            }
            if ((researchFlags = this.flags.get(string)) != null && (str = Arrays.stream(researchFlags.toArray(new IPlayerKnowledge.ResearchFlag[researchFlags.size()])).map(t -> t.name()).collect(Collectors.joining(","))) != null && !str.isEmpty()) {
                tag.m_128359_("flags", str);
            }
            researchList.add((Object)tag);
        }
        rootTag.m_128365_("research", (Tag)researchList);
        ListTag knowledgeList = new ListTag();
        for (KnowledgeType knowledgeKey : this.knowledge.keySet()) {
            Integer points;
            if (knowledgeKey == null || (points = this.knowledge.get((Object)knowledgeKey)) == null || points <= 0) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("key", knowledgeKey.name());
            tag.m_128405_("value", points.intValue());
            knowledgeList.add((Object)tag);
        }
        rootTag.m_128365_("knowledge", (Tag)knowledgeList);
        if (this.project != null) {
            rootTag.m_128365_("project", (Tag)this.project.serializeNBT());
        }
        if (this.topic != null) {
            rootTag.m_128365_("topic", (Tag)this.topic.serializeNBT());
        }
        ListTag listTag = new ListTag();
        for (AbstractResearchTopic topic : this.topicHistory) {
            listTag.add((Object)topic.serializeNBT());
        }
        rootTag.m_128365_("topicHistory", (Tag)listTag);
        rootTag.m_128356_("syncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public synchronized void deserializeNBT(@Nullable CompoundTag nbt) {
        if (nbt == null || nbt.m_128454_("syncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.m_128454_("syncTimestamp");
        this.clearResearch();
        this.clearKnowledge();
        this.project = null;
        ListTag researchList = nbt.m_128437_("research", 10);
        for (int index = 0; index < researchList.size(); ++index) {
            String flagStr;
            CompoundTag tag = researchList.m_128728_(index);
            SimpleResearchKey keyObj = SimpleResearchKey.parse(tag.m_128461_("key"));
            if (keyObj == null || this.isResearchKnown(keyObj)) continue;
            this.research.add(keyObj.getRootKey());
            int stage = tag.m_128451_("stage");
            if (stage > 0) {
                this.stages.put(keyObj.getRootKey(), stage);
            }
            if ((flagStr = tag.m_128461_("flags")) == null || flagStr.isEmpty()) continue;
            for (String flagName : flagStr.split(",")) {
                IPlayerKnowledge.ResearchFlag flag = null;
                try {
                    flag = IPlayerKnowledge.ResearchFlag.valueOf(flagName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addResearchFlag(keyObj, flag);
            }
        }
        ListTag knowledgeList = nbt.m_128437_("knowledge", 10);
        for (int index = 0; index < knowledgeList.size(); ++index) {
            CompoundTag tag = knowledgeList.m_128728_(index);
            String keyStr = tag.m_128461_("key");
            KnowledgeType key = null;
            try {
                key = KnowledgeType.valueOf(keyStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int points = tag.m_128451_("value");
            if (key == null) continue;
            this.knowledge.put(key, points);
        }
        if (nbt.m_128441_("project")) {
            this.project = ProjectFactory.getProjectFromNBT(nbt.m_128469_("project"));
        }
        if (nbt.m_128441_("topic")) {
            this.topic = ResearchTopicFactory.deserializeNBT(nbt.m_128469_("topic"));
        }
        ListTag historyList = nbt.m_128437_("topicHistory", 10);
        for (int index = 0; index < historyList.size(); ++index) {
            AbstractResearchTopic topic = ResearchTopicFactory.deserializeNBT(historyList.m_128728_(index));
            if (topic == null) continue;
            this.topicHistory.add(topic);
        }
    }

    @Override
    public void clearResearch() {
        this.research.clear();
        this.stages.clear();
        this.flags.clear();
        this.project = null;
        this.topic = null;
        this.topicHistory.clear();
    }

    @Override
    public void clearKnowledge() {
        this.knowledge.clear();
    }

    @Override
    @Nonnull
    public Set<SimpleResearchKey> getResearchSet() {
        return Collections.unmodifiableSet(this.research.stream().map(s -> SimpleResearchKey.parse(s)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public IPlayerKnowledge.ResearchStatus getResearchStatus(@Nullable SimpleResearchKey research) {
        if (!this.isResearchKnown(research)) {
            return IPlayerKnowledge.ResearchStatus.UNKNOWN;
        }
        ResearchEntry entry = ResearchEntries.getEntry(research);
        if (entry == null || entry.getStages().isEmpty() || this.getResearchStage(research) >= entry.getStages().size()) {
            return IPlayerKnowledge.ResearchStatus.COMPLETE;
        }
        return IPlayerKnowledge.ResearchStatus.IN_PROGRESS;
    }

    @Override
    public boolean isResearchComplete(@Nullable SimpleResearchKey research) {
        return this.getResearchStatus(research) == IPlayerKnowledge.ResearchStatus.COMPLETE;
    }

    @Override
    public boolean isResearchKnown(@Nullable SimpleResearchKey research) {
        if (research == null) {
            return false;
        }
        if ("".equals(research.getRootKey())) {
            return true;
        }
        if (research.hasStage() && this.getResearchStage(research) + 1 < research.getStage()) {
            return false;
        }
        return this.research.contains(research.getRootKey());
    }

    @Override
    public int getResearchStage(@Nullable SimpleResearchKey research) {
        if (research == null || research.getRootKey().isEmpty() || !this.research.contains(research.getRootKey())) {
            return -1;
        }
        return this.stages.getOrDefault(research.getRootKey(), 0);
    }

    @Override
    public boolean addResearch(@Nullable SimpleResearchKey research) {
        if (research != null && !this.isResearchKnown(research)) {
            this.research.add(research.getRootKey());
            return true;
        }
        return false;
    }

    @Override
    public boolean setResearchStage(@Nullable SimpleResearchKey research, int newStage) {
        if (research == null || research.getRootKey().isEmpty() || !this.research.contains(research.getRootKey()) || newStage <= 0) {
            return false;
        }
        this.stages.put(research.getRootKey(), newStage);
        return true;
    }

    @Override
    public boolean removeResearch(@Nullable SimpleResearchKey research) {
        if (research != null && this.isResearchKnown(research)) {
            this.research.remove(research.getRootKey());
            return true;
        }
        return false;
    }

    @Override
    public boolean addResearchFlag(@Nullable SimpleResearchKey research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        Set<IPlayerKnowledge.ResearchFlag> researchFlags = this.flags.get(research.getRootKey());
        if (researchFlags == null) {
            researchFlags = EnumSet.noneOf(IPlayerKnowledge.ResearchFlag.class);
            this.flags.put(research.getRootKey(), researchFlags);
        }
        return researchFlags.add(flag);
    }

    @Override
    public boolean removeResearchFlag(@Nullable SimpleResearchKey research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        return this.removeResearchFlagInner(research.getRootKey(), flag);
    }

    protected boolean removeResearchFlagInner(@Nonnull String researchKeyStr, @Nonnull IPlayerKnowledge.ResearchFlag flag) {
        Set<IPlayerKnowledge.ResearchFlag> researchFlags = this.flags.get(researchKeyStr);
        if (researchFlags != null) {
            boolean retVal = researchFlags.remove((Object)flag);
            if (researchFlags.isEmpty()) {
                this.flags.remove(researchKeyStr);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public boolean hasResearchFlag(@Nullable SimpleResearchKey research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        Set<IPlayerKnowledge.ResearchFlag> researchFlags = this.flags.get(research.getRootKey());
        return researchFlags != null && researchFlags.contains((Object)flag);
    }

    @Override
    @Nonnull
    public Set<IPlayerKnowledge.ResearchFlag> getResearchFlags(@Nullable SimpleResearchKey research) {
        if (research == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)this.flags.getOrDefault(research.getRootKey(), EnumSet.noneOf(IPlayerKnowledge.ResearchFlag.class)));
    }

    @Override
    public boolean addKnowledge(@Nullable KnowledgeType type, int amount) {
        if (type == null) {
            return false;
        }
        int points = this.getKnowledgeRaw(type) + amount;
        if (points < 0) {
            return false;
        }
        this.knowledge.put(type, points);
        return true;
    }

    @Override
    public int getKnowledge(@Nullable KnowledgeType type) {
        if (type == null) {
            return 0;
        }
        return (int)Math.floor((double)this.getKnowledgeRaw(type) / (double)type.getProgression());
    }

    @Override
    public int getKnowledgeRaw(@Nullable KnowledgeType type) {
        if (type == null) {
            return 0;
        }
        return this.knowledge.getOrDefault((Object)type, 0);
    }

    @Override
    public Project getActiveResearchProject() {
        return this.project;
    }

    @Override
    public void setActiveResearchProject(Project project) {
        this.project = project;
    }

    @Override
    public AbstractResearchTopic getLastResearchTopic() {
        return this.topic == null ? MainIndexResearchTopic.INSTANCE : this.topic;
    }

    @Override
    public void setLastResearchTopic(AbstractResearchTopic topic) {
        this.topic = topic;
    }

    @Override
    public LinkedList<AbstractResearchTopic> getResearchTopicHistory() {
        return this.topicHistory;
    }

    @Override
    public void setResearchTopicHistory(List<AbstractResearchTopic> history) {
        this.topicHistory.clear();
        this.topicHistory.addAll(history);
    }

    @Override
    public void sync(@Nullable ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncKnowledgePacket((Player)player), player);
            for (String keyStr : this.flags.keySet()) {
                this.removeResearchFlagInner(keyStr, IPlayerKnowledge.ResearchFlag.POPUP);
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_knowledge");
        private final IPlayerKnowledge instance = new PlayerKnowledge();
        private final LazyOptional<IPlayerKnowledge> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.KNOWLEDGE) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

