/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncLinguisticsPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerLinguistics
implements IPlayerLinguistics {
    private final Map<ResourceLocation, Integer> comprehension = new ConcurrentHashMap<ResourceLocation, Integer>();
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag comprehensionList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.comprehension.entrySet()) {
            if (entry == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Language", entry.getKey().toString());
            tag.m_128405_("Value", entry.getValue().intValue());
            comprehensionList.add((Object)tag);
        }
        rootTag.m_128365_("Comprehension", (Tag)comprehensionList);
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clear();
        ListTag comprehensionList = nbt.m_128437_("Comprehension", 10);
        for (int index = 0; index < comprehensionList.size(); ++index) {
            CompoundTag tag = comprehensionList.m_128728_(index);
            this.setComprehension(new ResourceLocation(tag.m_128461_("Language")), tag.m_128451_("Value"));
        }
    }

    @Override
    public void clear() {
        this.comprehension.clear();
    }

    @Override
    public boolean isLanguageKnown(ResourceLocation languageId) {
        return this.comprehension.containsKey(languageId);
    }

    @Override
    public int getComprehension(ResourceLocation languageId) {
        return this.comprehension.getOrDefault(languageId, 0);
    }

    @Override
    public void setComprehension(ResourceLocation languageId, int value) {
        this.comprehension.put(languageId, value);
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncLinguisticsPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_linguistics");
        private final IPlayerLinguistics instance = new PlayerLinguistics();
        private final LazyOptional<IPlayerLinguistics> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.LINGUISTICS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

