/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncStatsPacket;
import com.verdantartifice.primalmagick.common.stats.Stat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerStats
implements IPlayerStats {
    private final Map<ResourceLocation, Integer> stats = new ConcurrentHashMap<ResourceLocation, Integer>();
    private final Set<Long> discoveredShrines = ConcurrentHashMap.newKeySet();
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag statList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.stats.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Key", entry.getKey().toString());
            tag.m_128405_("Value", entry.getValue().intValue());
            statList.add((Object)tag);
        }
        rootTag.m_128365_("Stats", (Tag)statList);
        long[] locs = new long[this.discoveredShrines.size()];
        int index = 0;
        for (Long loc : this.discoveredShrines) {
            locs[index++] = loc;
        }
        rootTag.m_128365_("ShrineLocations", (Tag)new LongArrayTag(locs));
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        long[] locs;
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clear();
        ListTag statList = nbt.m_128437_("Stats", 10);
        for (int index = 0; index < statList.size(); ++index) {
            CompoundTag tag = statList.m_128728_(index);
            ResourceLocation loc = new ResourceLocation(tag.m_128461_("Key"));
            Integer value = tag.m_128451_("Value");
            this.stats.put(loc, value);
        }
        for (long loc : locs = nbt.m_128467_("ShrineLocations")) {
            this.discoveredShrines.add(loc);
        }
    }

    @Override
    public void clear() {
        this.stats.clear();
        this.discoveredShrines.clear();
    }

    @Override
    public int getValue(Stat stat) {
        if (stat == null) {
            return 0;
        }
        return this.stats.getOrDefault(stat.getLocation(), 0);
    }

    @Override
    public void setValue(Stat stat, int value) {
        if (stat != null) {
            this.stats.put(stat.getLocation(), value);
        }
    }

    @Override
    public boolean isLocationDiscovered(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        return this.discoveredShrines.contains(pos.m_121878_());
    }

    @Override
    public void setLocationDiscovered(BlockPos pos) {
        if (pos != null) {
            this.discoveredShrines.add(pos.m_121878_());
        }
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncStatsPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_stats");
        private final IPlayerStats instance = new PlayerStats();
        private final LazyOptional<IPlayerStats> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.STATS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

