/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncWardPacket;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerWard
implements IPlayerWard {
    protected static final List<EquipmentSlot> APPLICABLE_SLOTS = List.of(EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.FEET);
    protected static final int PAUSE_DURATION_MILLIS = 10000;
    private float current = 0.0f;
    private float max = 0.0f;
    private long lastPaused = 0L;
    private long syncTimestamp = 0L;

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        rootTag.m_128350_("Current", this.current);
        rootTag.m_128350_("Max", this.max);
        rootTag.m_128356_("LastPaused", this.lastPaused);
        rootTag.m_128356_("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128454_("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.clear();
        this.current = nbt.m_128457_("Current");
        this.max = nbt.m_128457_("Max");
        this.lastPaused = nbt.m_128454_("LastPaused");
    }

    @Override
    public List<EquipmentSlot> getApplicableSlots() {
        return APPLICABLE_SLOTS;
    }

    @Override
    public float getCurrentWard() {
        return this.current;
    }

    @Override
    public float getMaxWard() {
        return this.max;
    }

    @Override
    public void setCurrentWard(float ward) {
        this.current = Mth.m_14036_((float)ward, (float)0.0f, (float)this.getMaxWard());
    }

    @Override
    public void setMaxWard(float ward) {
        this.max = ward;
        this.current = Mth.m_14036_((float)this.current, (float)0.0f, (float)this.getMaxWard());
    }

    @Override
    public boolean isRegenerating() {
        return this.getCurrentWard() < this.getMaxWard() && System.currentTimeMillis() >= this.lastPaused + 10000L;
    }

    @Override
    public void pauseRegeneration() {
        this.lastPaused = System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.current = 0.0f;
        this.max = 0.0f;
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncWardPacket((Player)player), player);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_ward");
        private final IPlayerWard instance = new PlayerWard();
        private final LazyOptional<IPlayerWard> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.WARD) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

