/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.IWorldEntitySwappers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class PrimalMagickCapabilities {
    public static final Capability<IPlayerKnowledge> KNOWLEDGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerKnowledge>(){});
    public static final Capability<IPlayerCooldowns> COOLDOWNS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerCooldowns>(){});
    public static final Capability<IPlayerStats> STATS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerStats>(){});
    public static final Capability<IPlayerAttunements> ATTUNEMENTS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerAttunements>(){});
    public static final Capability<IPlayerCompanions> COMPANIONS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerCompanions>(){});
    public static final Capability<IPlayerArcaneRecipeBook> ARCANE_RECIPE_BOOK = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerArcaneRecipeBook>(){});
    public static final Capability<IPlayerWard> WARD = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerWard>(){});
    public static final Capability<IPlayerLinguistics> LINGUISTICS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerLinguistics>(){});
    public static final Capability<IWorldEntitySwappers> ENTITY_SWAPPERS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWorldEntitySwappers>(){});
    public static final Capability<IManaStorage> MANA_STORAGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IManaStorage>(){});
    public static final Capability<ITileResearchCache> RESEARCH_CACHE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITileResearchCache>(){});

    @Nonnull
    public static LazyOptional<IPlayerKnowledge> getKnowledge(@Nullable Player player) {
        return player == null ? LazyOptional.empty() : player.getCapability(KNOWLEDGE, null);
    }

    @Nullable
    public static IPlayerCooldowns getCooldowns(@Nullable Player player) {
        return player == null ? null : (IPlayerCooldowns)player.getCapability(COOLDOWNS, null).orElse(null);
    }

    @Nullable
    public static IPlayerStats getStats(@Nullable Player player) {
        return player == null ? null : (IPlayerStats)player.getCapability(STATS, null).orElse(null);
    }

    @Nullable
    public static IPlayerAttunements getAttunements(@Nullable Player player) {
        return player == null ? null : (IPlayerAttunements)player.getCapability(ATTUNEMENTS, null).orElse(null);
    }

    @Nullable
    public static IPlayerCompanions getCompanions(@Nullable Player player) {
        return player == null ? null : (IPlayerCompanions)player.getCapability(COMPANIONS, null).orElse(null);
    }

    @Nonnull
    public static LazyOptional<IPlayerArcaneRecipeBook> getArcaneRecipeBook(@Nullable Player player) {
        return player == null ? LazyOptional.empty() : player.getCapability(ARCANE_RECIPE_BOOK);
    }

    @Nonnull
    public static LazyOptional<IPlayerWard> getWard(@Nullable Player player) {
        return player == null ? LazyOptional.empty() : player.getCapability(WARD);
    }

    @Nonnull
    public static LazyOptional<IPlayerLinguistics> getLinguistics(@Nullable Player player) {
        return player == null ? LazyOptional.empty() : player.getCapability(LINGUISTICS);
    }

    @Nullable
    public static IWorldEntitySwappers getEntitySwappers(@Nonnull Level world) {
        return (IWorldEntitySwappers)world.getCapability(ENTITY_SWAPPERS, null).orElse(null);
    }

    @Nullable
    public static IManaStorage getManaStorage(@Nonnull BlockEntity tile) {
        return (IManaStorage)tile.getCapability(MANA_STORAGE, null).orElse(null);
    }

    @Nonnull
    public static LazyOptional<ITileResearchCache> getResearchCache(@Nonnull BlockEntity tile) {
        return tile.getCapability(RESEARCH_CACHE);
    }
}

