/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class TileResearchCache
implements ITileResearchCache {
    private final Set<String> research = ConcurrentHashMap.newKeySet();

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag researchList = new ListTag();
        for (String res : this.research) {
            researchList.add((Object)StringTag.m_129297_((String)res));
        }
        rootTag.m_128365_("research", (Tag)researchList);
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        this.clear();
        ListTag researchList = nbt.m_128437_("research", 8);
        for (int index = 0; index < researchList.size(); ++index) {
            String str = researchList.m_128778_(index);
            if (str == null || str.isEmpty()) continue;
            this.research.add(str);
        }
    }

    @Override
    public void clear() {
        this.research.clear();
    }

    @Override
    public boolean isResearchComplete(SimpleResearchKey key) {
        if (key == null) {
            return false;
        }
        if ("".equals(key.getRootKey())) {
            return true;
        }
        return this.research.contains(key.getRootKey());
    }

    @Override
    public boolean isResearchComplete(CompoundResearchKey key) {
        if (key == null) {
            return false;
        }
        return key.getRequireAll() ? this.isAllResearchComplete(key.getKeys()) : this.isAnyResearchComplete(key.getKeys());
    }

    protected boolean isAnyResearchComplete(@Nonnull List<SimpleResearchKey> keys) {
        for (SimpleResearchKey key : keys) {
            if (!this.isResearchComplete(key)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllResearchComplete(@Nonnull List<SimpleResearchKey> keys) {
        for (SimpleResearchKey key : keys) {
            if (this.isResearchComplete(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(Player player, Predicate<SimpleResearchKey> researchFilter) {
        PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
            this.clear();
            for (SimpleResearchKey key : knowledge.getResearchSet()) {
                if (!knowledge.isResearchComplete(key) || researchFilter != null && !researchFilter.test(key)) continue;
                this.research.add(key.getRootKey());
            }
        });
    }
}

