/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IWorldEntitySwappers;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WorldEntitySwappers
implements IWorldEntitySwappers {
    private final Queue<EntitySwapper> swappers = new LinkedBlockingQueue<EntitySwapper>();

    public CompoundTag serializeNBT() {
        CompoundTag rootTag = new CompoundTag();
        ListTag swapperList = new ListTag();
        for (EntitySwapper swapper : this.swappers) {
            if (swapper == null) continue;
            swapperList.add((Object)swapper.serializeNBT());
        }
        rootTag.m_128365_("Swappers", (Tag)swapperList);
        return rootTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        this.swappers.clear();
        ListTag swapperList = nbt.m_128437_("Swappers", 10);
        for (int index = 0; index < swapperList.size(); ++index) {
            CompoundTag swapperTag = swapperList.m_128728_(index);
            EntitySwapper swapper = new EntitySwapper(swapperTag);
            if (!swapper.isValid()) continue;
            this.swappers.offer(swapper);
        }
    }

    @Override
    public boolean enqueue(EntitySwapper swapper) {
        if (swapper == null) {
            return false;
        }
        return this.swappers.offer(swapper);
    }

    @Override
    public Queue<EntitySwapper> getQueue() {
        return this.swappers;
    }

    @Override
    public boolean setQueue(Queue<EntitySwapper> queue) {
        if (queue == null) {
            return false;
        }
        this.swappers.clear();
        for (EntitySwapper swapper : queue) {
            this.enqueue(swapper);
        }
        return true;
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = PrimalMagick.resource("capability_world_entity_swappers");
        private final IWorldEntitySwappers instance = new WorldEntitySwappers();
        private final LazyOptional<IWorldEntitySwappers> holder = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == PrimalMagickCapabilities.ENTITY_SWAPPERS) {
                return this.holder.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }
}

