/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.IAffinity;
import com.verdantartifice.primalmagick.common.affinities.ItemAffinity;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementTypeArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementTypeInput;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementValueArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeAmountArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeTypeArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeTypeInput;
import com.verdantartifice.primalmagick.common.commands.arguments.LanguageComprehensionArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.ResearchArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.ResearchInput;
import com.verdantartifice.primalmagick.common.commands.arguments.SourceArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.SourceInput;
import com.verdantartifice.primalmagick.common.commands.arguments.StatValueArgument;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipeBookItem;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.util.DataPackUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrimalMagickCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"primalmagick").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> PrimalMagickCommand.resetAll((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(Commands.m_82127_((String)"research").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"list").executes(context -> PrimalMagickCommand.listResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"grant_all").executes(context -> PrimalMagickCommand.grantAllResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"research", (ArgumentType)ResearchArgument.research()).executes(context -> PrimalMagickCommand.grantResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResearchArgument.getResearch(context, "research")))))).then(Commands.m_82127_((String)"grant_parents").then(Commands.m_82129_((String)"research", (ArgumentType)ResearchArgument.research()).executes(context -> PrimalMagickCommand.grantResearchParents((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResearchArgument.getResearch(context, "research")))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"research", (ArgumentType)ResearchArgument.research()).executes(context -> PrimalMagickCommand.revokeResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResearchArgument.getResearch(context, "research")))))).then(Commands.m_82127_((String)"details").then(Commands.m_82129_((String)"research", (ArgumentType)ResearchArgument.research()).executes(context -> PrimalMagickCommand.detailResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResearchArgument.getResearch(context, "research")))))).then(Commands.m_82127_((String)"progress").then(Commands.m_82129_((String)"research", (ArgumentType)ResearchArgument.research()).executes(context -> PrimalMagickCommand.progressResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResearchArgument.getResearch(context, "research")))))))).then(Commands.m_82127_((String)"knowledge").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetKnowledge((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"knowledge_type", (ArgumentType)KnowledgeTypeArgument.knowledgeType()).executes(context -> PrimalMagickCommand.getKnowledge((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), KnowledgeTypeArgument.getKnowledgeType(context, "knowledge_type")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"knowledge_type", (ArgumentType)KnowledgeTypeArgument.knowledgeType()).then(Commands.m_82129_((String)"points", (ArgumentType)KnowledgeAmountArgument.amount()).executes(context -> PrimalMagickCommand.addKnowledge((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), KnowledgeTypeArgument.getKnowledgeType(context, "knowledge_type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"points"))))))))).then(Commands.m_82127_((String)"scans").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(context -> PrimalMagickCommand.grantScanResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ItemArgument.m_120963_((CommandContext)context, (String)"item")))))).then(Commands.m_82127_((String)"grant_all").executes(context -> PrimalMagickCommand.grantAllScanResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))))).then(Commands.m_82127_((String)"sources").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"list").executes(context -> PrimalMagickCommand.listUnlockedSources((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"unlock_all").executes(context -> PrimalMagickCommand.unlockAllSources((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"source", (ArgumentType)SourceArgument.source()).executes(context -> PrimalMagickCommand.unlockSource((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), SourceArgument.getSource(context, "source")))))))).then(Commands.m_82127_((String)"stats").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetStats((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"stat", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82981_(StatsManager.getStatLocations().stream().map(ResourceLocation::toString), (SuggestionsBuilder)sb)).executes(context -> PrimalMagickCommand.getStatValue((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"stat")))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"stat", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82981_(StatsManager.getStatLocations().stream().map(ResourceLocation::toString), (SuggestionsBuilder)sb)).then(Commands.m_82129_((String)"value", (ArgumentType)StatValueArgument.value()).executes(context -> PrimalMagickCommand.setStatValue((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(Commands.m_82127_((String)"attunements").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetAttunements((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"source", (ArgumentType)SourceArgument.source()).executes(context -> PrimalMagickCommand.getAttunements((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), SourceArgument.getSource(context, "source")))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"source", (ArgumentType)SourceArgument.source()).then(Commands.m_82129_((String)"type", (ArgumentType)AttunementTypeArgument.attunementType()).then(Commands.m_82129_((String)"value", (ArgumentType)AttunementValueArgument.value()).executes(context -> PrimalMagickCommand.setAttunement((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), SourceArgument.getSource(context, "source"), AttunementTypeArgument.getAttunementType(context, "type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"affinities").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lint").executes(context -> PrimalMagickCommand.getSourcelessItems((CommandSourceStack)context.getSource(), Arrays.asList("minecraft", "primalmagick")))).then(Commands.m_82127_((String)"all").executes(context -> PrimalMagickCommand.getSourcelessItems((CommandSourceStack)context.getSource(), null))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"generateDatapack").executes(context -> PrimalMagickCommand.writeSourcelessItemDatapack((CommandSourceStack)context.getSource(), Arrays.asList("minecraft", "primalmagick")))).then(Commands.m_82127_((String)"all").executes(context -> PrimalMagickCommand.writeSourcelessItemDatapack((CommandSourceStack)context.getSource(), null))))).then(Commands.m_82127_((String)"explain").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(context -> PrimalMagickCommand.explainItemAffinity((CommandSourceStack)context.getSource(), ItemArgument.m_120963_((CommandContext)context, (String)"item"))))))).then(Commands.m_82127_((String)"recipes").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetRecipes((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"list").executes(context -> PrimalMagickCommand.listArcaneRecipes((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"sync").executes(context -> PrimalMagickCommand.syncArcaneRecipes((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121642_).executes(context -> PrimalMagickCommand.addArcaneRecipe((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe")))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121642_).executes(context -> PrimalMagickCommand.removeArcaneRecipe((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_106994_((CommandContext)context, (String)"recipe")))))))).then(Commands.m_82127_((String)"books").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"bookId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82957_(BooksPM.BOOKS.get().getKeys().stream(), (SuggestionsBuilder)sb)).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"bookId"), BookLanguagesPM.DEFAULT.getId(), OptionalInt.empty()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"languageId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82957_(BookLanguagesPM.LANGUAGES.get().getKeys().stream(), (SuggestionsBuilder)sb)).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"bookId"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"languageId"), OptionalInt.empty()))).then(Commands.m_82129_((String)"comprehension", (ArgumentType)LanguageComprehensionArgument.value()).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"bookId"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"languageId"), OptionalInt.of(IntegerArgumentType.getInteger((CommandContext)context, (String)"comprehension"))))))))))).then(Commands.m_82127_((String)"linguistics").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reset").executes(context -> PrimalMagickCommand.resetLinguistics((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"comprehension").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"languageId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82957_(BookLanguagesPM.LANGUAGES.get().getKeys().stream(), (SuggestionsBuilder)sb)).executes(context -> PrimalMagickCommand.getLanguageComprehension((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"languageId")))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"languageId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82957_(BookLanguagesPM.LANGUAGES.get().getKeys().stream(), (SuggestionsBuilder)sb)).then(Commands.m_82129_((String)"value", (ArgumentType)LanguageComprehensionArgument.value()).executes(context -> PrimalMagickCommand.setLanguageComprehension((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"languageId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pm").requires(source -> source.m_6761_(2))).redirect((CommandNode)node));
    }

    private static int resetAll(CommandSourceStack source, ServerPlayer player) {
        PrimalMagickCommand.resetResearch(source, player);
        PrimalMagickCommand.resetKnowledge(source, player);
        PrimalMagickCommand.resetAttunements(source, player);
        PrimalMagickCommand.resetStats(source, player);
        PrimalMagickCommand.resetRecipes(source, player);
        PrimalMagickCommand.resetLinguistics(source, player);
        return 0;
    }

    private static int listResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            Set<SimpleResearchKey> researchSet = knowledge.getResearchSet();
            CharSequence[] researchList = researchSet.stream().map(k -> k.getRootKey()).collect(Collectors.toSet()).toArray(new String[researchSet.size()]);
            String output = String.join((CharSequence)", ", researchList);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.list", (Object[])new Object[]{target.m_7755_(), output}), true);
        }
        return 0;
    }

    private static int resetResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            knowledge.clearResearch();
            ResearchManager.scheduleSync((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int grantResearch(CommandSourceStack source, ServerPlayer target, ResearchInput input) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        SimpleResearchKey key = input.getKey();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (ResearchEntries.getEntry(key) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.research.noexist", (Object[])new Object[]{key.toString()}));
        } else {
            ResearchManager.forceGrantWithAllParents((Player)target, key);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.grant", (Object[])new Object[]{target.m_7755_(), key.toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.grant.target", (Object[])new Object[]{source.m_81368_(), key.toString()}));
            }
        }
        return 0;
    }

    private static int grantResearchParents(CommandSourceStack source, ServerPlayer target, ResearchInput input) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        SimpleResearchKey key = input.getKey();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (ResearchEntries.getEntry(key) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.research.noexist", (Object[])new Object[]{key.toString()}));
        } else {
            ResearchManager.forceGrantParentsOnly((Player)target, key);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.grant_parents", (Object[])new Object[]{target.m_7755_(), key.toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.grant_parents.target", (Object[])new Object[]{source.m_81368_(), key.toString()}));
            }
        }
        return 0;
    }

    private static int grantAllResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            ResearchManager.forceGrantAll((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.grant_all", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.grant_all.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int revokeResearch(CommandSourceStack source, ServerPlayer target, ResearchInput input) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        SimpleResearchKey key = input.getKey();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (ResearchEntries.getEntry(key) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.research.noexist", (Object[])new Object[]{key.toString()}));
        } else {
            ResearchManager.forceRevokeWithAllChildren((Player)target, key);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.revoke", (Object[])new Object[]{target.m_7755_(), key.toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.revoke.target", (Object[])new Object[]{source.m_81368_(), key.toString()}));
            }
        }
        return 0;
    }

    private static int detailResearch(CommandSourceStack source, ServerPlayer target, ResearchInput input) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        SimpleResearchKey key = input.getKey();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (ResearchEntries.getEntry(key) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.research.noexist", (Object[])new Object[]{key.toString()}));
        } else {
            IPlayerKnowledge.ResearchStatus status = knowledge.getResearchStatus(key);
            int stage = knowledge.getResearchStage(key);
            Set<IPlayerKnowledge.ResearchFlag> flagSet = knowledge.getResearchFlags(key);
            CharSequence[] flagStrs = flagSet.stream().map(f -> f.name()).collect(Collectors.toSet()).toArray(new String[flagSet.size()]);
            String flagOutput = flagStrs.length == 0 ? "none" : String.join((CharSequence)", ", flagStrs);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.details.1", (Object[])new Object[]{key.toString(), target.m_7755_()}), true);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.details.2", (Object[])new Object[]{status.name()}), true);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.details.3", (Object[])new Object[]{stage}), true);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.details.4", (Object[])new Object[]{flagOutput}), true);
        }
        return 0;
    }

    private static int progressResearch(CommandSourceStack source, ServerPlayer target, ResearchInput input) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        SimpleResearchKey key = input.getKey();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (ResearchEntries.getEntry(key) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.research.noexist", (Object[])new Object[]{key.toString()}));
        } else {
            int oldStage = knowledge.getResearchStage(key);
            if (ResearchManager.progressResearch((Player)target, key)) {
                int newStage = knowledge.getResearchStage(key);
                source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.progress.success", (Object[])new Object[]{key.toString(), target.m_7755_(), oldStage, newStage}), true);
                if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                    target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.research.progress.target", (Object[])new Object[]{key.toString(), source.m_81368_(), oldStage, newStage}));
                }
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.research.progress.failure", (Object[])new Object[]{key.toString(), oldStage}), true);
            }
        }
        return 0;
    }

    private static int resetKnowledge(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            knowledge.clearKnowledge();
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.knowledge.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.knowledge.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int getKnowledge(CommandSourceStack source, ServerPlayer target, KnowledgeTypeInput knowledgeTypeInput) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        KnowledgeType type = knowledgeTypeInput.getType();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (type == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.knowledge_type.noexist"));
        } else {
            int levels = knowledge.getKnowledge(type);
            int points = knowledge.getKnowledgeRaw(type);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.knowledge.get", (Object[])new Object[]{target.m_7755_(), levels, type.name(), points}), true);
        }
        return 0;
    }

    private static int addKnowledge(CommandSourceStack source, ServerPlayer target, KnowledgeTypeInput knowledgeTypeInput, int points) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)target).orElse(null);
        KnowledgeType type = knowledgeTypeInput.getType();
        if (knowledge == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (type == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.knowledge_type.noexist"));
        } else if (ResearchManager.addKnowledge((Player)target, type, points)) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.knowledge.add.success", (Object[])new Object[]{points, type.name(), target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.knowledge.add.target", (Object[])new Object[]{points, type.name(), source.m_81368_()}));
            }
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.knowledge.add.failure", (Object[])new Object[]{target.m_7755_()}), true);
        }
        return 0;
    }

    private static int grantScanResearch(CommandSourceStack source, ServerPlayer target, ItemInput item) {
        ItemStack stack;
        try {
            stack = item.m_120980_(1, false);
        }
        catch (CommandSyntaxException e) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.scans.grant.failure", (Object[])new Object[]{target.m_7755_()}));
            return 0;
        }
        if (ResearchManager.setScanned(stack, target)) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.scans.grant.success", (Object[])new Object[]{target.m_7755_(), ForgeRegistries.ITEMS.getKey((Object)item.m_120979_()).toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.scans.grant.target", (Object[])new Object[]{source.m_81368_(), ForgeRegistries.ITEMS.getKey((Object)item.m_120979_()).toString()}));
            }
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.scans.grant.failure", (Object[])new Object[]{target.m_7755_()}));
        }
        return 0;
    }

    private static int grantAllScanResearch(CommandSourceStack source, ServerPlayer target) {
        int count = ResearchManager.setAllScanned(target);
        source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.scans.grant_all", (Object[])new Object[]{count, target.m_7755_()}), true);
        if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
            target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.scans.grant_all.target", (Object[])new Object[]{count, source.m_81368_()}));
        }
        return 0;
    }

    private static int listUnlockedSources(CommandSourceStack source, ServerPlayer target) {
        List unlockedTags = Source.SORTED_SOURCES.stream().filter(s -> s.isDiscovered((Player)target)).map(s -> s.getTag().toUpperCase()).collect(Collectors.toList());
        String tagStr = String.join((CharSequence)", ", unlockedTags);
        source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.sources.list", (Object[])new Object[]{target.m_7755_(), tagStr}), true);
        return 0;
    }

    private static int unlockAllSources(CommandSourceStack source, ServerPlayer target) {
        int unlocked = 0;
        for (Source toUnlock : Source.SOURCES.values()) {
            if (toUnlock.isDiscovered((Player)target) || !ResearchManager.completeResearch((Player)target, toUnlock.getDiscoverKey())) continue;
            ++unlocked;
        }
        int totalUnlocked = unlocked;
        source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.sources.unlock_all", (Object[])new Object[]{target.m_7755_(), totalUnlocked}), true);
        if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
            target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.sources.unlock_all.target", (Object[])new Object[]{source.m_81368_(), totalUnlocked}));
        }
        return 0;
    }

    private static int unlockSource(CommandSourceStack source, ServerPlayer target, SourceInput input) {
        String tag = input.getSourceTag();
        Source toUnlock = Source.getSource(tag.toLowerCase());
        if (toUnlock == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.source.noexist", (Object[])new Object[]{tag}));
        } else if (toUnlock.isDiscovered((Player)target)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.sources.unlock.already_unlocked", (Object[])new Object[]{target.m_7755_(), tag.toUpperCase()}));
        } else if (ResearchManager.completeResearch((Player)target, toUnlock.getDiscoverKey())) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.sources.unlock.success", (Object[])new Object[]{target.m_7755_(), tag.toUpperCase()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.sources.unlock.target", (Object[])new Object[]{source.m_81368_(), tag.toUpperCase()}));
            }
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.sources.unlock.failure", (Object[])new Object[]{target.m_7755_(), tag.toUpperCase()}));
        }
        return 0;
    }

    private static int getStatValue(CommandSourceStack source, ServerPlayer target, ResourceLocation statLoc) {
        Stat stat = StatsManager.getStat(statLoc);
        if (stat == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.stats.noexist", (Object[])new Object[]{statLoc}));
        } else {
            MutableComponent statName = Component.m_237115_((String)stat.getTranslationKey());
            Component statValue = StatsManager.getFormattedValue((Player)target, stat);
            source.m_288197_(() -> PrimalMagickCommand.lambda$getStatValue$72(target, (Component)statName, statValue), true);
        }
        return 0;
    }

    private static int setStatValue(CommandSourceStack source, ServerPlayer target, ResourceLocation statLoc, int value) {
        Stat stat = StatsManager.getStat(statLoc);
        if (stat == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.stats.noexist", (Object[])new Object[]{statLoc}));
        } else {
            StatsManager.setValue((Player)target, stat, value);
            MutableComponent statName = Component.m_237115_((String)stat.getTranslationKey());
            Component statValue = StatsManager.getFormattedValue((Player)target, stat);
            source.m_288197_(() -> PrimalMagickCommand.lambda$setStatValue$73(target, (Component)statName, statValue), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.stats.set.target", (Object[])new Object[]{source.m_81368_(), statName, statValue}));
            }
        }
        return 0;
    }

    private static int resetStats(CommandSourceStack source, ServerPlayer target) {
        IPlayerStats stats = PrimalMagickCapabilities.getStats((Player)target);
        if (stats == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            stats.clear();
            StatsManager.scheduleSync((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.stats.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.stats.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int resetAttunements(CommandSourceStack source, ServerPlayer target) {
        IPlayerAttunements attunements = PrimalMagickCapabilities.getAttunements((Player)target);
        if (attunements == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            attunements.clear();
            AttunementManager.removeAllAttributeModifiers((Player)target);
            AttunementManager.scheduleSync((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.attunements.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.attunements.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int getAttunements(CommandSourceStack source, ServerPlayer target, SourceInput input) {
        String tag = input.getSourceTag();
        Source toQuery = Source.getSource(tag.toLowerCase());
        if (toQuery == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.source.noexist", (Object[])new Object[]{tag}));
        } else {
            MutableComponent sourceText = Component.m_237115_((String)toQuery.getNameTranslationKey());
            source.m_288197_(() -> PrimalMagickCommand.lambda$getAttunements$76((Component)sourceText, source, target, toQuery), true);
            for (AttunementType type : AttunementType.values()) {
                MutableComponent typeText = Component.m_237115_((String)type.getNameTranslationKey());
                source.m_288197_(() -> PrimalMagickCommand.lambda$getAttunements$77((Component)typeText, target, toQuery, type), true);
            }
        }
        return 0;
    }

    private static int setAttunement(CommandSourceStack source, ServerPlayer target, SourceInput input, AttunementTypeInput attunementType, int value) {
        String tag = input.getSourceTag();
        Source toSet = Source.getSource(tag.toLowerCase());
        AttunementType type = attunementType.getType();
        if (toSet == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.source.noexist", (Object[])new Object[]{tag}));
        } else if (type == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.attunement_type.noexist"));
        } else {
            AttunementManager.setAttunement((Player)target, toSet, type, value);
            MutableComponent sourceText = Component.m_237115_((String)toSet.getNameTranslationKey());
            MutableComponent typeText = Component.m_237115_((String)type.getNameTranslationKey());
            if (type.isCapped() && value > type.getMaximum()) {
                source.m_288197_(() -> PrimalMagickCommand.lambda$setAttunement$78(target, (Component)typeText, (Component)sourceText, type, value), true);
                if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                    target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.attunements.set.target.capped", (Object[])new Object[]{target.m_7755_(), typeText, sourceText, type.getMaximum(), value}));
                }
            } else {
                source.m_288197_(() -> PrimalMagickCommand.lambda$setAttunement$79(target, (Component)typeText, (Component)sourceText, value), true);
                if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                    target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.attunements.set.target", (Object[])new Object[]{target.m_7755_(), typeText, sourceText, value}));
                }
            }
        }
        return 0;
    }

    private static int getSourcelessItems(CommandSourceStack source, Collection<String> excludeNamespaces) {
        ServerPlayer target = source.m_230896_();
        Logger LOGGER = LogManager.getLogger();
        ServerLevel level = source.m_81372_();
        RecipeManager recipeManager = source.getRecipeManager();
        RegistryAccess registryAccess = source.m_5894_();
        List<Item> sourcelessItems = PrimalMagickCommand.listSourcelessItems(recipeManager, registryAccess, level, excludeNamespaces);
        Object excludeNote = "";
        if (excludeNamespaces != null && excludeNamespaces.size() > 0) {
            excludeNote = " excluding resource namespaces: " + String.join((CharSequence)", ", excludeNamespaces);
        }
        target.m_240418_((Component)Component.m_237113_((String)("Found " + Integer.toString(sourcelessItems.size()) + " items without sources" + (String)excludeNote + "; check system logs for details")), false);
        LOGGER.info("Items with no sources: " + sourcelessItems.stream().map(item -> ForgeRegistries.ITEMS.getKey(item)).toList().toString());
        return 0;
    }

    private static int writeSourcelessItemDatapack(CommandSourceStack source, Collection<String> excludeNamespaces) {
        byte[] itemsToDataPackTemplate;
        Logger LOGGER = LogManager.getLogger();
        ServerPlayer target = source.m_230896_();
        ServerLevel level = source.m_81372_();
        RecipeManager recipeManager = source.getRecipeManager();
        RegistryAccess registryAccess = source.m_5894_();
        List<Item> sourcelessItems = PrimalMagickCommand.listSourcelessItems(recipeManager, registryAccess, level, excludeNamespaces);
        List<EntityType<?>> sourcelessEntities = PrimalMagickCommand.listSourcelessEntityTypes(registryAccess, excludeNamespaces);
        try {
            itemsToDataPackTemplate = DataPackUtils.ItemsToDataPackTemplate(sourcelessItems, sourcelessEntities);
        }
        catch (IOException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("unable to generate datapack");
            return 1;
        }
        try {
            File tempFile = File.createTempFile("primalMagickDataPack", ".zip");
            String filePath = tempFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(itemsToDataPackTemplate);
            fos.close();
            target.m_213846_((Component)Component.m_237113_((String)"Wrote datapack template for sourceless items and entities to disk; check system logs for location."));
            LOGGER.atInfo().log("Wrote Datapack to " + filePath);
        }
        catch (IOException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("unable to write datapack");
            return 1;
        }
        return 0;
    }

    private static List<EntityType<?>> listSourcelessEntityTypes(RegistryAccess registryAccess, Collection<String> excludeNamespaces) {
        AffinityManager am = AffinityManager.getOrCreateInstance();
        Vector retVal = new Vector();
        ForgeRegistries.ENTITY_TYPES.forEach(entityType -> {
            ResourceLocation resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            if (resourceLocation == null) {
                return;
            }
            String namespace = resourceLocation.m_135827_();
            if (excludeNamespaces != null && excludeNamespaces.contains(namespace)) {
                return;
            }
            CompletableFuture<SourceList> future = am.getAffinityValuesAsync((EntityType<?>)entityType, registryAccess);
            try {
                SourceList sources = future.get();
                if (sources.isEmpty()) {
                    retVal.add((EntityType<?>)entityType);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
        return retVal;
    }

    private static List<Item> listSourcelessItems(RecipeManager recipeManager, RegistryAccess registryAccess, ServerLevel level, Collection<String> excludeNamespaces) {
        AffinityManager am = AffinityManager.getOrCreateInstance();
        Vector<Item> items = new Vector<Item>();
        ForgeRegistries.ITEMS.forEach(item -> {
            ItemStack stack = item.m_7968_();
            ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey(item);
            if (resourceLocation == null) {
                return;
            }
            String namespace = resourceLocation.m_135827_();
            if (excludeNamespaces != null && excludeNamespaces.contains(namespace)) {
                return;
            }
            CompletableFuture<SourceList> f = am.getAffinityValuesAsync(stack, (Level)level);
            try {
                SourceList sources = f.get();
                if (sources.isEmpty() && PrimalMagickCommand.getRecipeCountForItem(recipeManager, registryAccess, item) == 0L) {
                    items.add((Item)item);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
        return items;
    }

    private static long getRecipeCountForItem(RecipeManager recipeManager, RegistryAccess registryAccess, Item item) {
        long count = recipeManager.m_44051_().stream().filter(r -> r.m_8043_(registryAccess) != null && r.m_8043_(registryAccess).m_41720_().equals(item)).count();
        return count;
    }

    private static int resetRecipes(CommandSourceStack source, ServerPlayer target) {
        IPlayerArcaneRecipeBook recipeBook = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            recipeBook.get().clear();
            ArcaneRecipeBookManager.scheduleSync((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.recipes.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int listArcaneRecipes(CommandSourceStack source, ServerPlayer target) {
        IPlayerArcaneRecipeBook recipeBook = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            Set<ResourceLocation> knownSet = recipeBook.get().getKnown();
            CharSequence[] knownList = knownSet.stream().map(r -> r.toString()).collect(Collectors.toSet()).toArray(new String[knownSet.size()]);
            String knownOutput = String.join((CharSequence)", ", knownList);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.list.known", (Object[])new Object[]{target.m_7755_(), knownOutput}), true);
            Set<ResourceLocation> highlightSet = recipeBook.get().getHighlight();
            CharSequence[] highlightList = highlightSet.stream().map(r -> r.toString()).collect(Collectors.toSet()).toArray(new String[highlightSet.size()]);
            String highlightOutput = String.join((CharSequence)", ", highlightList);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.list.highlight", (Object[])new Object[]{target.m_7755_(), highlightOutput}), true);
        }
        return 0;
    }

    private static int syncArcaneRecipes(CommandSourceStack source, ServerPlayer target) {
        if (!ArcaneRecipeBookManager.syncRecipesWithResearch(target)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.sync", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.recipes.sync.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int addArcaneRecipe(CommandSourceStack source, ServerPlayer target, Recipe<?> recipe) {
        IPlayerArcaneRecipeBook recipeBook = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (!(recipe instanceof IArcaneRecipeBookItem)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.recipes.recipe_not_arcane"));
        } else {
            ArcaneRecipeBookManager.addRecipes(Collections.singletonList(recipe), target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.add", (Object[])new Object[]{target.m_7755_(), recipe.m_6423_().toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.recipes.add.target", (Object[])new Object[]{source.m_81368_(), recipe.m_6423_().toString()}));
            }
        }
        return 0;
    }

    private static int removeArcaneRecipe(CommandSourceStack source, ServerPlayer target, Recipe<?> recipe) {
        IPlayerArcaneRecipeBook recipeBook = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else if (!(recipe instanceof IArcaneRecipeBookItem)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.recipes.recipe_not_arcane"));
        } else {
            ArcaneRecipeBookManager.removeRecipes(Collections.singletonList(recipe), target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.recipes.remove", (Object[])new Object[]{target.m_7755_(), recipe.m_6423_().toString()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.recipes.remove.target", (Object[])new Object[]{source.m_81368_(), recipe.m_6423_().toString()}));
            }
        }
        return 0;
    }

    private static int giveBook(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation bookId, ResourceLocation bookLanguageId, OptionalInt comprehension) {
        if (!BooksPM.BOOKS.get().containsKey(bookId)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.books.noexist", (Object[])new Object[]{bookId.toString()}));
        } else if (!BookLanguagesPM.LANGUAGES.get().containsKey(bookLanguageId)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.books.nolanguage", (Object[])new Object[]{bookLanguageId.toString()}));
        } else {
            ItemStack bookStack = new ItemStack((ItemLike)ItemsPM.STATIC_BOOK.get());
            StaticBookItem.setBookDefinition(bookStack, (BookDefinition)BooksPM.BOOKS.get().getValue(bookId));
            StaticBookItem.setBookLanguage(bookStack, (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(bookLanguageId));
            StaticBookItem.setGeneration(bookStack, 0);
            StaticBookItem.setTranslatedComprehension(bookStack, comprehension);
            for (ServerPlayer serverPlayer : targets) {
                ItemEntity bookEntity;
                ItemStack bookCopy = bookStack.m_41777_();
                if (serverPlayer.m_150109_().m_36054_(bookCopy) || (bookEntity = serverPlayer.m_36176_(bookCopy, false)) == null) continue;
                bookEntity.m_32061_();
                bookEntity.m_266426_(serverPlayer.m_20148_());
            }
            if (targets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, bookStack.m_41611_(), ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.give.success.multiple", (Object[])new Object[]{1, bookStack.m_41611_(), targets.size()}), true);
            }
        }
        return targets.size();
    }

    private static int resetLinguistics(CommandSourceStack source, ServerPlayer target) {
        IPlayerLinguistics linguistics = (IPlayerLinguistics)PrimalMagickCapabilities.getLinguistics((Player)target).orElse(null);
        if (linguistics == null) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.primalmagick.error"));
        } else {
            linguistics.clear();
            LinguisticsManager.scheduleSync((Player)target);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.linguistics.reset", (Object[])new Object[]{target.m_7755_()}), true);
            if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.linguistics.reset.target", (Object[])new Object[]{source.m_81368_()}));
            }
        }
        return 0;
    }

    private static int getLanguageComprehension(CommandSourceStack source, ServerPlayer target, ResourceLocation bookLanguageId) {
        if (!BookLanguagesPM.LANGUAGES.get().containsKey(bookLanguageId)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.books.nolanguage", (Object[])new Object[]{bookLanguageId.toString()}));
        } else {
            BookLanguage lang = (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(bookLanguageId);
            source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.linguistics.comprehension.get", (Object[])new Object[]{target.m_7755_(), bookLanguageId, LinguisticsManager.getComprehension((Player)target, lang)}), true);
        }
        return 0;
    }

    private static int setLanguageComprehension(CommandSourceStack source, ServerPlayer target, ResourceLocation bookLanguageId, int value) {
        if (!BookLanguagesPM.LANGUAGES.get().containsKey(bookLanguageId)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.books.nolanguage", (Object[])new Object[]{bookLanguageId.toString()}));
        } else {
            BookLanguage lang = (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(bookLanguageId);
            LinguisticsManager.setComprehension((Player)target, lang, value);
            int newValue = LinguisticsManager.getComprehension((Player)target, lang);
            if (value > lang.complexity()) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.linguistics.comprehension.set.success.capped", (Object[])new Object[]{target.m_7755_(), bookLanguageId, lang.complexity(), newValue}), true);
                if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                    target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.linguistics.comprehension.set.target.capped", (Object[])new Object[]{source.m_81368_(), bookLanguageId, lang.complexity(), newValue}));
                }
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.linguistics.comprehension.set.success", (Object[])new Object[]{target.m_7755_(), bookLanguageId, newValue}), true);
                if (source.m_230896_() == null || source.m_230896_().m_19879_() != target.m_19879_()) {
                    target.m_213846_((Component)Component.m_237110_((String)"commands.primalmagick.linguistics.comprehension.set.target", (Object[])new Object[]{source.m_81368_(), bookLanguageId, newValue}));
                }
            }
        }
        return 0;
    }

    private static int explainItemAffinity(CommandSourceStack source, ItemInput item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item.m_120979_());
        IAffinity affinityData = AffinityManager.getInstance().getOrGenerateItemAffinityAsync(itemId, source.getRecipeManager(), source.m_5894_(), new ArrayList<ResourceLocation>()).join();
        if (affinityData instanceof ItemAffinity) {
            ItemAffinity itemAffinity = (ItemAffinity)affinityData;
            itemAffinity.getSourceRecipe().ifPresentOrElse(recipeLoc -> source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.affinities.explain.from_recipe", (Object[])new Object[]{itemId.toString(), recipeLoc.toString()}), true), () -> source.m_288197_(() -> Component.m_237110_((String)"commands.primalmagick.affinities.explain.from_data", (Object[])new Object[]{itemId.toString()}), true));
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.primalmagick.affinities.explain.not_found", (Object[])new Object[]{itemId.toString()}));
        }
        return 0;
    }

    private static /* synthetic */ Component lambda$setAttunement$79(ServerPlayer target, Component typeText, Component sourceText, int value) {
        return Component.m_237110_((String)"commands.primalmagick.attunements.set.success", (Object[])new Object[]{target.m_7755_(), typeText, sourceText, value});
    }

    private static /* synthetic */ Component lambda$setAttunement$78(ServerPlayer target, Component typeText, Component sourceText, AttunementType type, int value) {
        return Component.m_237110_((String)"commands.primalmagick.attunements.set.success.capped", (Object[])new Object[]{target.m_7755_(), typeText, sourceText, type.getMaximum(), value});
    }

    private static /* synthetic */ Component lambda$getAttunements$77(Component typeText, ServerPlayer target, Source toQuery, AttunementType type) {
        return Component.m_237110_((String)"commands.primalmagick.attunements.get.partial", (Object[])new Object[]{typeText, AttunementManager.getAttunement((Player)target, toQuery, type)});
    }

    private static /* synthetic */ Component lambda$getAttunements$76(Component sourceText, CommandSourceStack source, ServerPlayer target, Source toQuery) {
        return Component.m_237110_((String)"commands.primalmagick.attunements.get.total", (Object[])new Object[]{sourceText, source.m_81368_(), AttunementManager.getTotalAttunement((Player)target, toQuery)});
    }

    private static /* synthetic */ Component lambda$setStatValue$73(ServerPlayer target, Component statName, Component statValue) {
        return Component.m_237110_((String)"commands.primalmagick.stats.set", (Object[])new Object[]{target.m_7755_(), statName, statValue});
    }

    private static /* synthetic */ Component lambda$getStatValue$72(ServerPlayer target, Component statName, Component statValue) {
        return Component.m_237110_((String)"commands.primalmagick.stats.get", (Object[])new Object[]{target.m_7755_(), statName, statValue});
    }
}

