/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.verdantartifice.primalmagick.common.commands.arguments.DisciplineInput;
import com.verdantartifice.primalmagick.common.commands.arguments.DisciplineParser;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import java.util.concurrent.CompletableFuture;

public class DisciplineArgument
implements ArgumentType<DisciplineInput> {
    public static DisciplineArgument discipline() {
        return new DisciplineArgument();
    }

    public DisciplineInput parse(StringReader reader) throws CommandSyntaxException {
        DisciplineParser parser = new DisciplineParser(reader).parse();
        return new DisciplineInput(parser.getDisciplineKey());
    }

    public static <S> DisciplineInput getDiscipline(CommandContext<S> context, String name) {
        return (DisciplineInput)context.getArgument(name, DisciplineInput.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toUpperCase();
        for (ResearchDiscipline discipline : ResearchDisciplines.getAllDisciplines()) {
            String key = discipline.getKey().toUpperCase();
            if (!key.startsWith(remaining)) continue;
            builder.suggest(key);
        }
        return builder.buildFuture();
    }
}

