/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.verdantartifice.primalmagick.common.commands.arguments.SourceInput;
import com.verdantartifice.primalmagick.common.commands.arguments.SourceParser;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.concurrent.CompletableFuture;

public class SourceArgument
implements ArgumentType<SourceInput> {
    public static SourceArgument source() {
        return new SourceArgument();
    }

    public SourceInput parse(StringReader reader) throws CommandSyntaxException {
        SourceParser parser = new SourceParser(reader).parse();
        return new SourceInput(parser.getSourceTag());
    }

    public static <S> SourceInput getSource(CommandContext<S> context, String name) {
        return (SourceInput)context.getArgument(name, SourceInput.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toUpperCase();
        for (Source source : Source.SOURCES.values()) {
            String key = source.getTag().toUpperCase();
            if (!key.startsWith(remaining)) continue;
            builder.suggest(key);
        }
        return builder.buildFuture();
    }
}

