/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.concoctions;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class ConcoctionUtils {
    public static ItemStack newConcoction(Potion potion, ConcoctionType type) {
        return ConcoctionUtils.setConcoctionType(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ItemsPM.CONCOCTION.get()), (Potion)potion), type);
    }

    public static ItemStack newBomb(Potion potion, FuseType fuse) {
        return ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ItemsPM.ALCHEMICAL_BOMB.get()), (Potion)potion), ConcoctionType.BOMB), fuse);
    }

    @Nullable
    public static ConcoctionType getConcoctionType(@Nonnull ItemStack stack) {
        return ConcoctionType.fromName(stack.m_41784_().m_128461_("ConcoctionType"));
    }

    @Nonnull
    public static ItemStack setConcoctionType(@Nonnull ItemStack stack, @Nullable ConcoctionType concoctionType) {
        if (concoctionType != null) {
            stack.m_41784_().m_128359_("ConcoctionType", concoctionType.m_7912_());
            ConcoctionUtils.setCurrentDoses(stack, concoctionType.getMaxDoses());
        }
        return stack;
    }

    public static int getCurrentDoses(@Nonnull ItemStack stack) {
        return stack.m_41784_().m_128451_("ConcoctionDoses");
    }

    @Nonnull
    public static ItemStack setCurrentDoses(@Nonnull ItemStack stack, int doses) {
        ConcoctionType type = ConcoctionUtils.getConcoctionType(stack);
        stack.m_41784_().m_128405_("ConcoctionDoses", Math.min(type == null ? 1 : type.getMaxDoses(), doses));
        return stack;
    }

    @Nullable
    public static FuseType getFuseType(@Nonnull ItemStack stack) {
        return FuseType.fromName(stack.m_41784_().m_128461_("BombFuse"));
    }

    @Nonnull
    public static ItemStack setFuseType(@Nonnull ItemStack stack, @Nullable FuseType fuseType) {
        if (fuseType != null) {
            stack.m_41784_().m_128359_("BombFuse", fuseType.m_7912_());
        }
        return stack;
    }

    public static boolean hasBeneficialEffect(@Nonnull Potion potion) {
        for (MobEffectInstance instance : potion.m_43488_()) {
            if (!instance.m_19544_().m_19486_()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBomb(@Nonnull ItemStack stack) {
        return stack.m_41720_() == ItemsPM.ALCHEMICAL_BOMB.get();
    }
}

