/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.concoctions;

import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;

public enum FuseType implements StringRepresentable
{
    IMPACT(-1, "impact"),
    SHORT(20, "short"),
    MEDIUM(60, "medium"),
    LONG(100, "long");

    private final int fuseLength;
    private final String tag;

    private FuseType(int fuseLength, String tag) {
        this.fuseLength = fuseLength;
        this.tag = tag;
    }

    public int getFuseLength() {
        return this.fuseLength;
    }

    public String m_7912_() {
        return this.tag;
    }

    public boolean hasTimer() {
        return this.fuseLength > 0;
    }

    @Nullable
    public FuseType getNext() {
        switch (this) {
            case IMPACT: {
                return SHORT;
            }
            case SHORT: {
                return MEDIUM;
            }
            case MEDIUM: {
                return LONG;
            }
            case LONG: {
                return IMPACT;
            }
        }
        return null;
    }

    public String getTranslationKey() {
        return "concoctions.primalmagick.fuse." + this.tag;
    }

    @Nullable
    public static FuseType fromName(@Nullable String name) {
        for (FuseType type : FuseType.values()) {
            if (!type.m_7912_().equals(name)) continue;
            return type;
        }
        return null;
    }
}

