/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockIngredient
implements Predicate<Block> {
    public static final BlockIngredient EMPTY = new BlockIngredient(Stream.empty());
    protected final IBlockList[] acceptedBlocks;
    protected Block[] matchingBlocks = null;

    protected BlockIngredient(Stream<? extends IBlockList> blockLists) {
        this.acceptedBlocks = (IBlockList[])blockLists.toArray(IBlockList[]::new);
    }

    public Block[] getMatchingBlocks() {
        this.determineMatchingBlocks();
        return this.matchingBlocks;
    }

    protected void determineMatchingBlocks() {
        if (this.matchingBlocks == null) {
            this.matchingBlocks = (Block[])Arrays.stream(this.acceptedBlocks).flatMap(blockList -> blockList.getBlocks().stream()).distinct().toArray(Block[]::new);
        }
    }

    @Override
    public boolean test(@Nullable Block testBlock) {
        if (testBlock == null) {
            return false;
        }
        this.determineMatchingBlocks();
        for (Block block : this.matchingBlocks) {
            if (testBlock != block) continue;
            return true;
        }
        return false;
    }

    public void write(FriendlyByteBuf buf) {
        this.determineMatchingBlocks();
        buf.m_130130_(this.matchingBlocks.length);
        for (int index = 0; index < this.matchingBlocks.length; ++index) {
            buf.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)this.matchingBlocks[index]));
        }
    }

    public JsonElement serialize() {
        if (this.acceptedBlocks.length == 1) {
            return this.acceptedBlocks[0].serialize();
        }
        JsonArray arr = new JsonArray();
        for (IBlockList list : this.acceptedBlocks) {
            arr.add((JsonElement)list.serialize());
        }
        return arr;
    }

    public boolean hasNoMatchingBlocks() {
        return this.acceptedBlocks.length == 0 && (this.matchingBlocks == null || this.matchingBlocks.length == 0);
    }

    public Ingredient asIngredient() {
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])Arrays.stream(this.acceptedBlocks).flatMap(ibl -> ibl.getBlocks().stream()).toArray(ItemLike[]::new)));
    }

    protected static BlockIngredient fromBlockListStream(Stream<? extends IBlockList> stream) {
        BlockIngredient ing = new BlockIngredient(stream);
        return ing.acceptedBlocks.length == 0 ? EMPTY : ing;
    }

    public static BlockIngredient fromBlocks(Block ... blocks) {
        return BlockIngredient.fromBlockListStream(Arrays.stream(blocks).map(b -> new SingleBlockList((Block)b)));
    }

    public static BlockIngredient fromTag(TagKey<Block> tag) {
        return BlockIngredient.fromBlockListStream(Stream.of(new TagList(tag)));
    }

    public static BlockIngredient read(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        return BlockIngredient.fromBlockListStream(Stream.generate(() -> {
            ResourceLocation loc = buf.m_130281_();
            return new SingleBlockList((Block)ForgeRegistries.BLOCKS.getValue(loc));
        }).limit(size));
    }

    protected static IBlockList deserializeBlockList(JsonObject json) {
        if (json.has("block") && json.has("tag")) {
            throw new JsonParseException("A block ingredient entry is either a tag or a block, not both");
        }
        if (json.has("block")) {
            ResourceLocation loc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(loc);
            if (block == null) {
                throw new JsonSyntaxException("Unknown block '" + loc.toString() + "'");
            }
            return new SingleBlockList(block);
        }
        if (json.has("tag")) {
            ResourceLocation loc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)loc);
            return new TagList((TagKey<Block>)tag);
        }
        throw new JsonParseException("A block ingredient entry needs either a tag or a block");
    }

    public static BlockIngredient deserialize(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return BlockIngredient.fromBlockListStream(Stream.of(BlockIngredient.deserializeBlockList(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray arr = json.getAsJsonArray();
                if (arr.size() == 0) {
                    throw new JsonSyntaxException("Block array cannot be empty, at least one block must be defined");
                }
                return BlockIngredient.fromBlockListStream(StreamSupport.stream(arr.spliterator(), false).map(element -> BlockIngredient.deserializeBlockList(GsonHelper.m_13918_((JsonElement)element, (String)"block"))));
            }
            throw new JsonSyntaxException("Expected block to be object or array of objects");
        }
        throw new JsonSyntaxException("Block cannot be null");
    }

    protected static interface IBlockList {
        public Collection<Block> getBlocks();

        public JsonObject serialize();
    }

    protected static class TagList
    implements IBlockList {
        private final TagKey<Block> tag;

        public TagList(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<Block> getBlocks() {
            ArrayList<Block> retVal = new ArrayList<Block>();
            for (Block block : ForgeRegistries.BLOCKS.tags().getTag(this.tag)) {
                retVal.add(block);
            }
            return retVal;
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.f_203868_().toString());
            return json;
        }
    }

    protected static class SingleBlockList
    implements IBlockList {
        private final Block block;

        public SingleBlockList(Block block) {
            this.block = block;
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.block);
        }

        @Override
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)this.block).toString());
            return json;
        }
    }
}

