/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;

public class ConcoctingRecipe
implements IConcoctingRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final CompoundResearchKey research;
    protected final SourceList manaCosts;
    protected final ItemStack recipeOutput;
    protected final NonNullList<Ingredient> recipeItems;
    protected final boolean isSimple;

    public ConcoctingRecipe(ResourceLocation id, String group, CompoundResearchKey research, SourceList manaCosts, ItemStack output, NonNullList<Ingredient> items) {
        this.id = id;
        this.group = group;
        this.research = research;
        this.manaCosts = manaCosts;
        this.recipeOutput = output;
        this.recipeItems = items;
        this.isSimple = items.stream().allMatch(Ingredient::isSimple);
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        StackedContents helper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int count = 0;
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack stack = inv.m_8020_(index);
            if (stack.m_41619_()) continue;
            ++count;
            if (this.isSimple) {
                helper.m_36468_(stack, 1);
                continue;
            }
            inputs.add(stack);
        }
        return count == this.recipeItems.size() && (this.isSimple ? helper.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.recipeOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.CONCOCTING.get();
    }

    @Override
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public CompoundResearchKey getRequiredResearch() {
        return this.research;
    }

    public String m_6076_() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<ConcoctingRecipe> {
        public ConcoctingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CompoundResearchKey research = CompoundResearchKey.parse(GsonHelper.m_13851_((JsonObject)json, (String)"research", (String)""));
            SourceList manaCosts = JsonUtils.toSourceList(GsonHelper.m_13841_((JsonObject)json, (String)"mana", (JsonObject)new JsonObject()));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            NonNullList<Ingredient> ingredients = this.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for concocting recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for concocting recipe the max is 9");
            }
            return new ConcoctingRecipe(recipeId, group, research, manaCosts, result, ingredients);
        }

        protected NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList retVal = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                retVal.add((Object)ingredient);
            }
            return retVal;
        }

        public ConcoctingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CompoundResearchKey research = CompoundResearchKey.parse(buffer.m_130136_(Short.MAX_VALUE));
            SourceList manaCosts = SourceList.fromNetwork(buffer);
            int count = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new ConcoctingRecipe(recipeId, group, research, manaCosts, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, ConcoctingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.research.toString());
            SourceList.toNetwork(buffer, recipe.manaCosts);
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

