/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class DissolutionRecipe
implements IDissolutionRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final SourceList manaCosts;

    public DissolutionRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, SourceList manaCosts) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
        this.manaCosts = manaCosts;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.DISSOLUTION.get();
    }

    @Override
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    public String m_6076_() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<DissolutionRecipe> {
        public DissolutionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            SourceList manaCosts = JsonUtils.toSourceList(GsonHelper.m_13841_((JsonObject)json, (String)"mana", (JsonObject)new JsonObject()));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Ingredient ing = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            return new DissolutionRecipe(recipeId, group, ing, result, manaCosts);
        }

        public DissolutionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            SourceList manaCosts = SourceList.fromNetwork(buffer);
            Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new DissolutionRecipe(recipeId, group, ing, result, manaCosts);
        }

        public void toNetwork(FriendlyByteBuf buffer, DissolutionRecipe recipe) {
            buffer.m_130070_(recipe.group);
            SourceList.toNetwork(buffer, recipe.manaCosts);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

