/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;

public class RitualRecipe
implements IRitualRecipe {
    public static final int MIN_INSTABILITY = 0;
    public static final int MAX_INSTABILITY = 10;
    protected final ResourceLocation id;
    protected final String group;
    protected final CompoundResearchKey research;
    protected final SourceList manaCosts;
    protected final int instability;
    protected final ItemStack recipeOutput;
    protected final NonNullList<Ingredient> recipeItems;
    protected final NonNullList<BlockIngredient> recipeProps;
    protected final boolean isSimple;

    public RitualRecipe(ResourceLocation id, String group, CompoundResearchKey research, SourceList manaCosts, int instability, ItemStack output, NonNullList<Ingredient> items, NonNullList<BlockIngredient> props) {
        this.id = id;
        this.group = group;
        this.research = research;
        this.manaCosts = manaCosts;
        this.instability = instability;
        this.recipeOutput = output;
        this.recipeItems = items;
        this.recipeProps = props;
        this.isSimple = items.stream().allMatch(Ingredient::isSimple);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        StackedContents helper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int count = 0;
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack stack = inv.m_8020_(index);
            if (stack.m_41619_()) continue;
            ++count;
            if (this.isSimple) {
                helper.m_36468_(stack, 1);
                continue;
            }
            inputs.add(stack);
        }
        return count == this.recipeItems.size() && (this.isSimple ? helper.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        return this.recipeOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.RITUAL.get();
    }

    @Override
    public CompoundResearchKey getRequiredResearch() {
        return this.research;
    }

    @Override
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public NonNullList<BlockIngredient> getProps() {
        return this.recipeProps;
    }

    @Override
    public int getInstability() {
        return this.instability;
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipe> {
        public RitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CompoundResearchKey research = CompoundResearchKey.parse(GsonHelper.m_13851_((JsonObject)json, (String)"research", (String)""));
            SourceList manaCosts = JsonUtils.toSourceList(GsonHelper.m_13841_((JsonObject)json, (String)"mana", (JsonObject)new JsonObject()));
            int instability = GsonHelper.m_13824_((JsonObject)json, (String)"instability", (int)0);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            NonNullList<Ingredient> ingredients = this.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            NonNullList<BlockIngredient> props = this.readProps(GsonHelper.m_13832_((JsonObject)json, (String)"props", (JsonArray)new JsonArray()));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for ritual recipe");
            }
            return new RitualRecipe(recipeId, group, research, manaCosts, instability, result, ingredients, props);
        }

        protected NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList retVal = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                retVal.add((Object)ingredient);
            }
            return retVal;
        }

        protected NonNullList<BlockIngredient> readProps(JsonArray jsonArray) {
            NonNullList retVal = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                BlockIngredient ingredient = BlockIngredient.deserialize(jsonArray.get(i));
                if (ingredient.hasNoMatchingBlocks()) continue;
                retVal.add((Object)ingredient);
            }
            return retVal;
        }

        public RitualRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CompoundResearchKey research = CompoundResearchKey.parse(buffer.m_130136_(Short.MAX_VALUE));
            int instability = buffer.m_130242_();
            SourceList manaCosts = SourceList.fromNetwork(buffer);
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int propCount = buffer.m_130242_();
            NonNullList props = NonNullList.m_122780_((int)propCount, (Object)BlockIngredient.EMPTY);
            for (int index = 0; index < props.size(); ++index) {
                props.set(index, (Object)BlockIngredient.read(buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new RitualRecipe(recipeId, group, research, manaCosts, instability, result, (NonNullList<Ingredient>)ingredients, (NonNullList<BlockIngredient>)props);
        }

        public void toNetwork(FriendlyByteBuf buffer, RitualRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.research.toString());
            buffer.m_130130_(recipe.instability);
            SourceList.toNetwork(buffer, recipe.manaCosts);
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.recipeProps.size());
            for (BlockIngredient prop : recipe.recipeProps) {
                prop.write(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

