/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class RunecarvingRecipe
implements IRunecarvingRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final CompoundResearchKey research;
    protected final Ingredient ingredient1;
    protected final Ingredient ingredient2;
    protected final ItemStack result;

    public RunecarvingRecipe(ResourceLocation id, String group, CompoundResearchKey research, Ingredient ingredient1, Ingredient ingredient2, ItemStack result) {
        this.id = id;
        this.group = group;
        this.research = research;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.result = result;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.ingredient1.test(inv.m_8020_(0)) && this.ingredient2.test(inv.m_8020_(1));
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient1);
        nonnulllist.add((Object)this.ingredient2);
        return nonnulllist;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.RUNECARVING.get();
    }

    @Override
    public CompoundResearchKey getRequiredResearch() {
        return this.research;
    }

    public static class Serializer
    implements RecipeSerializer<RunecarvingRecipe> {
        public RunecarvingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ing2;
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CompoundResearchKey research = CompoundResearchKey.parse(GsonHelper.m_13851_((JsonObject)json, (String)"research", (String)""));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            Ingredient ing1 = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient1") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient1")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient1"));
            Ingredient ingredient = ing2 = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient2") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient2")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient2"));
            if (ing1.m_43947_() && ing2.m_43947_()) {
                throw new JsonParseException("No ingredients for runecarving recipe");
            }
            return new RunecarvingRecipe(recipeId, group, research, ing1, ing2, result);
        }

        public RunecarvingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CompoundResearchKey research = CompoundResearchKey.parse(buffer.m_130136_(Short.MAX_VALUE));
            Ingredient ing1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ing2 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new RunecarvingRecipe(recipeId, group, research, ing1, ing2, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, RunecarvingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.research.toString());
            recipe.ingredient1.m_43923_(buffer);
            recipe.ingredient2.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

