/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.JsonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapedArcaneRecipe
implements IArcaneRecipe,
IShapedRecipe<CraftingContainer> {
    protected final int recipeWidth;
    protected final int recipeHeight;
    protected final NonNullList<Ingredient> recipeItems;
    protected final ItemStack recipeOutput;
    protected final ResourceLocation id;
    protected final String group;
    protected final CompoundResearchKey research;
    protected final SourceList manaCosts;

    public ShapedArcaneRecipe(ResourceLocation id, String group, CompoundResearchKey research, SourceList manaCosts, int width, int height, NonNullList<Ingredient> items, ItemStack output) {
        this.id = id;
        this.group = group;
        this.research = research;
        this.manaCosts = manaCosts;
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = items;
        this.recipeOutput = output;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        for (int i = 0; i <= inv.m_39347_() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(CraftingContainer inv, int widthOffset, int heightOffset, boolean flag) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - widthOffset;
                int l = j - heightOffset;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = flag ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        return this.recipeOutput.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.ARCANE_CRAFTING_SHAPED.get();
    }

    @Override
    public CompoundResearchKey getRequiredResearch() {
        return this.research;
    }

    @Override
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }

    public String m_6076_() {
        return this.group;
    }

    protected static Map<String, Ingredient> deserializeKey(JsonObject jsonObject) {
        HashMap<String, Ingredient> map = new HashMap<String, Ingredient>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    protected static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int width, int height) {
        NonNullList list = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        HashSet<String> keySet = new HashSet<String>(keys.keySet());
        keySet.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[0].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                keySet.remove(s);
                list.set(j + width * i, (Object)ingredient);
            }
        }
        if (!keySet.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keySet);
        }
        return list;
    }

    protected static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, ShapedArcaneRecipe.firstNonSpace(s));
            int j1 = ShapedArcaneRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        return ingredients.isEmpty() || ingredients.stream().filter(i -> !i.m_43947_()).anyMatch(i -> i.m_43908_().length == 0);
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    protected static String[] patternFromJson(JsonArray jsonArray) {
        String[] astring = new String[jsonArray.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedArcaneRecipe> {
        public ShapedArcaneRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CompoundResearchKey research = CompoundResearchKey.parse(GsonHelper.m_13851_((JsonObject)json, (String)"research", (String)""));
            SourceList manaCosts = JsonUtils.toSourceList(GsonHelper.m_13841_((JsonObject)json, (String)"mana", (JsonObject)new JsonObject()));
            Map<String, Ingredient> map = ShapedArcaneRecipe.deserializeKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] patternStrs = ShapedArcaneRecipe.shrink(ShapedArcaneRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = patternStrs[0].length();
            int height = patternStrs.length;
            NonNullList<Ingredient> ingredients = ShapedArcaneRecipe.deserializeIngredients(patternStrs, map, width, height);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapedArcaneRecipe(recipeId, group, research, manaCosts, width, height, ingredients, result);
        }

        public ShapedArcaneRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CompoundResearchKey research = CompoundResearchKey.parse(buffer.m_130136_(Short.MAX_VALUE));
            SourceList manaCosts = SourceList.fromNetwork(buffer);
            NonNullList list = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int index = 0; index < list.size(); ++index) {
                list.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack stack = buffer.m_130267_();
            return new ShapedArcaneRecipe(recipeId, group, research, manaCosts, width, height, (NonNullList<Ingredient>)list, stack);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedArcaneRecipe recipe) {
            buffer.m_130130_(recipe.recipeWidth);
            buffer.m_130130_(recipe.recipeHeight);
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.research.toString());
            SourceList.toNetwork(buffer, recipe.manaCosts);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

