/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class StaticBookCloningRecipe
extends CustomRecipe {
    public StaticBookCloningRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pContainer, Level pLevel) {
        int count = 0;
        ItemStack bookStack = ItemStack.f_41583_;
        for (int index = 0; index < pContainer.m_6643_(); ++index) {
            ItemStack slotStack = pContainer.m_8020_(index);
            if (slotStack.m_41619_()) continue;
            if (slotStack.m_150930_((Item)ItemsPM.STATIC_BOOK.get())) {
                if (!bookStack.m_41619_()) {
                    return false;
                }
                bookStack = slotStack;
                continue;
            }
            if (slotStack.m_150930_(Items.f_42614_)) {
                ++count;
                continue;
            }
            return false;
        }
        return !bookStack.m_41619_() && StaticBookItem.getBookId(bookStack).isPresent() && count > 0;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        int count = 0;
        ItemStack originalStack = ItemStack.f_41583_;
        for (int index = 0; index < pContainer.m_6643_(); ++index) {
            ItemStack slotStack = pContainer.m_8020_(index);
            if (slotStack.m_41619_()) continue;
            if (slotStack.m_150930_((Item)ItemsPM.STATIC_BOOK.get())) {
                if (!originalStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                originalStack = slotStack;
                continue;
            }
            if (slotStack.m_150930_(Items.f_42614_)) {
                ++count;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (!originalStack.m_41619_() && StaticBookItem.getBookId(originalStack).isPresent() && count > 0 && StaticBookItem.getGeneration(originalStack) < 2) {
            ItemStack copyStack = originalStack.m_255036_(count);
            StaticBookItem.setGeneration(copyStack, StaticBookItem.getGeneration(originalStack) + 1);
            return copyStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList retVal = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int index = 0; index < retVal.size(); ++index) {
            ItemStack inputStack = pContainer.m_8020_(index);
            if (inputStack.hasCraftingRemainingItem()) {
                retVal.set(index, (Object)inputStack.getCraftingRemainingItem());
                continue;
            }
            Item item = inputStack.m_41720_();
            if (!(item instanceof StaticBookItem)) continue;
            StaticBookItem bookItem = (StaticBookItem)item;
            retVal.set(index, (Object)inputStack.m_255036_(1));
            break;
        }
        return retVal;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersPM.STATIC_BOOK_CLONING.get();
    }
}

