/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipeBookItem;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;

public class ArcaneRecipeBookManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.m_20148_());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.m_20148_());
        }
    }

    public static void addRecipes(Collection<Recipe<?>> recipes, ServerPlayer serverPlayer) {
        PrimalMagickCapabilities.getArcaneRecipeBook((Player)serverPlayer).ifPresent(recipeBook -> {
            for (Recipe recipe : recipes) {
                IArcaneRecipeBookItem arbi;
                if (!(recipe instanceof IArcaneRecipeBookItem) || (arbi = (IArcaneRecipeBookItem)recipe).isArcaneSpecial()) continue;
                recipeBook.get().add(recipe);
                recipeBook.get().addHighlight(recipe);
            }
        });
        ArcaneRecipeBookManager.scheduleSync((Player)serverPlayer);
    }

    public static void removeRecipes(Collection<Recipe<?>> recipes, ServerPlayer serverPlayer) {
        PrimalMagickCapabilities.getArcaneRecipeBook((Player)serverPlayer).ifPresent(recipeBook -> {
            for (Recipe recipe : recipes) {
                recipeBook.get().remove(recipe);
            }
        });
        ArcaneRecipeBookManager.scheduleSync((Player)serverPlayer);
    }

    public static boolean containsRecipe(Player player, Recipe<?> recipe) {
        IPlayerArcaneRecipeBook book = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook(player).orElse(null);
        return book != null && book.get().contains(recipe);
    }

    public static boolean syncRecipesWithResearch(ServerPlayer player) {
        IPlayerArcaneRecipeBook recipeBook = (IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook((Player)player).orElse(null);
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge((Player)player).orElse(null);
        if (recipeBook == null || knowledge == null) {
            return false;
        }
        recipeBook.get().clear();
        RecipeManager recipeManager = player.m_9236_().m_7465_();
        HashSet<ResourceLocation> idsToAdd = new HashSet<ResourceLocation>();
        for (ResearchEntry entry : ResearchEntries.getAllEntries()) {
            if (!knowledge.isResearchKnown(entry.getKey())) continue;
            idsToAdd.addAll(entry.getKnownRecipeIds((Player)player));
        }
        ArcaneRecipeBookManager.addRecipes(idsToAdd.stream().map(id -> recipeManager.m_44043_(id).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()), player);
        return true;
    }
}

