/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;

public class ArcaneRecipeBookSettings {
    private static final Map<ArcaneRecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)ArcaneRecipeBookType.CRAFTING), (Object)Pair.of((Object)"isArcaneWorkbenchGuiOpen", (Object)"isArcaneWorkbenchFilteringCraftable"), (Object)((Object)ArcaneRecipeBookType.CONCOCTER), (Object)Pair.of((Object)"isConcocterGuiOpen", (Object)"isConcocterFilteringCraftable"), (Object)((Object)ArcaneRecipeBookType.DISSOLUTION), (Object)Pair.of((Object)"isDissolutionGuiOpen", (Object)"isDissolutionFilteringCraftable"), (Object)((Object)ArcaneRecipeBookType.FURNACE), (Object)Pair.of((Object)"isInfernalFurnaceGuiOpen", (Object)"isInfernalFurnaceFilteringCraftable"));
    private final Map<ArcaneRecipeBookType, TypeSettings> states;

    private ArcaneRecipeBookSettings(Map<ArcaneRecipeBookType, TypeSettings> states) {
        this.states = states;
    }

    public ArcaneRecipeBookSettings() {
        this((Map)Util.m_137469_((Object)Maps.newEnumMap(ArcaneRecipeBookType.class), map -> {
            for (ArcaneRecipeBookType type : ArcaneRecipeBookType.values()) {
                map.put(type, new TypeSettings(false, false));
            }
        }));
    }

    public boolean isOpen(ArcaneRecipeBookType type) {
        return this.states.get((Object)((Object)type)).open;
    }

    public void setOpen(ArcaneRecipeBookType type, boolean open) {
        this.states.get((Object)((Object)type)).open = open;
    }

    public boolean isFiltering(ArcaneRecipeBookType type) {
        return this.states.get((Object)((Object)type)).filtering;
    }

    public void setFiltering(ArcaneRecipeBookType type, boolean filtering) {
        this.states.get((Object)((Object)type)).filtering = filtering;
    }

    public void clear() {
        for (ArcaneRecipeBookType type : ArcaneRecipeBookType.values()) {
            this.setOpen(type, false);
            this.setFiltering(type, false);
        }
    }

    public static ArcaneRecipeBookSettings read(CompoundTag tag) {
        EnumMap map = Maps.newEnumMap(ArcaneRecipeBookType.class);
        TAG_FIELDS.forEach((type, pair) -> map.put(type, new TypeSettings(tag.m_128471_((String)pair.getFirst()), tag.m_128471_((String)pair.getSecond()))));
        return new ArcaneRecipeBookSettings(map);
    }

    public void write(CompoundTag tag) {
        TAG_FIELDS.forEach((type, pair) -> {
            TypeSettings typeSettings = this.states.get(type);
            tag.m_128379_((String)pair.getFirst(), typeSettings.open);
            tag.m_128379_((String)pair.getSecond(), typeSettings.filtering);
        });
    }

    public ArcaneRecipeBookSettings copy() {
        EnumMap map = Maps.newEnumMap(ArcaneRecipeBookType.class);
        for (ArcaneRecipeBookType type : ArcaneRecipeBookType.values()) {
            map.put(type, this.states.get((Object)type).copy());
        }
        return new ArcaneRecipeBookSettings(map);
    }

    public void replaceFrom(ArcaneRecipeBookSettings other) {
        this.states.clear();
        for (ArcaneRecipeBookType type : ArcaneRecipeBookType.values()) {
            this.states.put(type, other.states.get((Object)type).copy());
        }
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArcaneRecipeBookSettings other = (ArcaneRecipeBookSettings)obj;
        return Objects.equals(this.states, other.states);
    }

    protected static class TypeSettings {
        public boolean open;
        public boolean filtering;

        public TypeSettings(boolean open, boolean filtering) {
            this.open = open;
            this.filtering = filtering;
        }

        public TypeSettings copy() {
            return new TypeSettings(this.open, this.filtering);
        }

        public int hashCode() {
            return Objects.hash(this.filtering, this.open);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeSettings other = (TypeSettings)obj;
            return this.filtering == other.filtering && this.open == other.open;
        }

        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }
    }
}

