/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.StackedNbtContents;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.recipe_book.PlaceGhostArcaneRecipePacket;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlaceArcaneRecipe<C extends Container>
implements PlaceRecipe<Integer> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final StackedNbtContents stackedContents = new StackedNbtContents();
    protected final IArcaneRecipeBookMenu<C> menu;
    protected Inventory inventory;

    public ServerPlaceArcaneRecipe(IArcaneRecipeBookMenu<C> menu) {
        this.menu = menu;
    }

    public void recipeClicked(ServerPlayer player, @Nullable Recipe<C> recipe, boolean shiftDown) {
        if (recipe != null) {
            boolean inVanillaBook = player.m_8952_().m_12709_(recipe);
            boolean inArcaneBook = ArcaneRecipeBookManager.containsRecipe((Player)player, recipe);
            if (inVanillaBook || inArcaneBook) {
                this.inventory = player.m_150109_();
                if (this.testClearGrid() || player.m_7500_()) {
                    this.stackedContents.m_36453_();
                    player.m_150109_().m_36010_((StackedContents)this.stackedContents);
                    this.menu.fillCraftSlotsStackedContents(this.stackedContents);
                    if (this.stackedContents.m_36475_(recipe, null)) {
                        this.handleRecipeClicked(recipe, shiftDown);
                    } else {
                        this.clearGrid();
                        PacketHandler.sendToPlayer(new PlaceGhostArcaneRecipePacket(player.f_36096_.f_38840_, recipe), player);
                    }
                    player.m_150109_().m_6596_();
                }
            }
        }
    }

    protected void clearGrid() {
        for (int index = 0; index < this.menu.getSize(); ++index) {
            if (!this.menu.shouldMoveToInventory(index)) continue;
            ItemStack stack = this.menu.m_38853_(index).m_7993_().m_41777_();
            this.inventory.m_150076_(stack, false);
            this.menu.m_38853_(index).m_5852_(stack);
        }
        this.menu.clearCraftingContent();
    }

    protected void handleRecipeClicked(Recipe<C> recipe, boolean shiftDown) {
        int stackSize;
        IntArrayList list;
        boolean matches = this.menu.recipeMatches(recipe);
        int i = this.stackedContents.m_36493_(recipe, null);
        if (matches) {
            for (int index = 0; index < this.menu.getGridHeight() * this.menu.getGridWidth() + 1; ++index) {
                ItemStack stack;
                if (index == this.menu.getResultSlotIndex() || (stack = this.menu.m_38853_(index).m_7993_()).m_41619_() || Math.min(i, stack.m_41741_()) >= stack.m_41613_() + 1) continue;
                return;
            }
        }
        if (this.stackedContents.m_36478_(recipe, (IntList)(list = new IntArrayList()), stackSize = this.getStackSize(shiftDown, i, matches))) {
            int curSize = stackSize;
            IntListIterator intListIterator = list.iterator();
            while (intListIterator.hasNext()) {
                int value = (Integer)intListIterator.next();
                int size = StackedContents.m_36454_((int)value).m_41741_();
                if (size >= curSize) continue;
                curSize = size;
            }
            if (this.stackedContents.m_36478_(recipe, (IntList)list, curSize)) {
                this.clearGrid();
                this.m_135408_(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, (Iterator)list.iterator(), curSize);
            }
        }
    }

    public void m_5817_(Iterator<Integer> iterator, int slotIndex, int count, int p_135418_, int p_135419_) {
        Slot slot = this.menu.m_38853_(slotIndex);
        int itemId = iterator.next();
        ItemStack stack = StackedContents.m_36454_((int)itemId);
        if (this.stackedContents.hasNbtData(itemId)) {
            stack.m_41751_(this.stackedContents.getNbtData(itemId));
        }
        if (!stack.m_41619_()) {
            for (int index = 0; index < count; ++index) {
                this.moveItemToGrid(slot, stack);
            }
        }
    }

    protected int getStackSize(boolean shiftDown, int stackSize, boolean matches) {
        int retVal = 1;
        if (shiftDown) {
            retVal = stackSize;
        } else if (matches) {
            retVal = 64;
            for (int index = 0; index < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++index) {
                ItemStack stack;
                if (index == this.menu.getResultSlotIndex() || (stack = this.menu.m_38853_(index).m_7993_()).m_41619_() || retVal <= stack.m_41613_()) continue;
                retVal = stack.m_41613_();
            }
            if (retVal < 64) {
                ++retVal;
            }
        }
        return retVal;
    }

    protected void moveItemToGrid(Slot slot, ItemStack stack) {
        ItemStack invStack;
        int index = this.inventory.m_36043_(stack);
        if (index != -1 && !(invStack = this.inventory.m_8020_(index).m_41777_()).m_41619_()) {
            if (invStack.m_41613_() > 1) {
                this.inventory.m_7407_(index, 1);
            } else {
                this.inventory.m_8016_(index);
            }
            invStack.m_41764_(1);
            if (slot.m_7993_().m_41619_()) {
                slot.m_5852_(invStack);
            } else {
                slot.m_7993_().m_41769_(1);
            }
        }
    }

    protected boolean testClearGrid() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int count = this.getAmountOfFreeSlotsInInventory();
        for (int index = 0; index < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++index) {
            ItemStack stack;
            if (index == this.menu.getResultSlotIndex() || (stack = this.menu.m_38853_(index).m_7993_().m_41777_()).m_41619_()) continue;
            int slotIndex = this.inventory.m_36050_(stack);
            if (slotIndex == -1 && stackList.size() < count) {
                for (ItemStack listStack : stackList) {
                    if (!ItemStack.m_41656_((ItemStack)listStack, (ItemStack)stack) || listStack.m_41613_() == listStack.m_41741_() || listStack.m_41613_() + stack.m_41613_() > listStack.m_41741_()) continue;
                    listStack.m_41769_(stack.m_41613_());
                    stack.m_41764_(0);
                    break;
                }
                if (stack.m_41619_()) continue;
                if (stackList.size() >= count) {
                    return false;
                }
                stackList.add(stack);
                continue;
            }
            if (slotIndex != -1) continue;
            return false;
        }
        return true;
    }

    protected int getAmountOfFreeSlotsInInventory() {
        int retVal = 0;
        for (ItemStack stack : this.inventory.f_35974_) {
            if (!stack.m_41619_()) continue;
            ++retVal;
        }
        return retVal;
    }
}

