/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.damagesource;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;

public class DamageTypesPM {
    private static final Map<Source, ResourceKey<DamageType>> SORCERY_MAP = new HashMap<Source, ResourceKey<DamageType>>();
    public static final ResourceKey<DamageType> BLEEDING = DamageTypesPM.create("bleeding");
    public static final ResourceKey<DamageType> BLOOD_ROSE = DamageTypesPM.create("blood_rose");
    public static final ResourceKey<DamageType> HELLISH_CHAIN = DamageTypesPM.create("hellish_chain");
    public static final ResourceKey<DamageType> SORCERY_EARTH = DamageTypesPM.createSorcery("sorcery_earth", Source.EARTH);
    public static final ResourceKey<DamageType> SORCERY_SEA = DamageTypesPM.createSorcery("sorcery_sea", Source.SEA);
    public static final ResourceKey<DamageType> SORCERY_SKY = DamageTypesPM.createSorcery("sorcery_sky", Source.SKY);
    public static final ResourceKey<DamageType> SORCERY_SUN = DamageTypesPM.createSorcery("sorcery_sun", Source.SUN);
    public static final ResourceKey<DamageType> SORCERY_MOON = DamageTypesPM.createSorcery("sorcery_moon", Source.MOON);
    public static final ResourceKey<DamageType> SORCERY_BLOOD = DamageTypesPM.createSorcery("sorcery_blood", Source.BLOOD);
    public static final ResourceKey<DamageType> SORCERY_INFERNAL = DamageTypesPM.createSorcery("sorcery_infernal", Source.INFERNAL);
    public static final ResourceKey<DamageType> SORCERY_VOID = DamageTypesPM.createSorcery("sorcery_void", Source.VOID);
    public static final ResourceKey<DamageType> SORCERY_HALLOWED = DamageTypesPM.createSorcery("sorcery_hallowed", Source.HALLOWED);

    private static ResourceKey<DamageType> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)PrimalMagick.resource(name));
    }

    private static ResourceKey<DamageType> createSorcery(String name, Source source) {
        if (source == null || SORCERY_MAP.containsKey(source)) {
            return null;
        }
        ResourceKey<DamageType> resourceKey = DamageTypesPM.create(name);
        SORCERY_MAP.put(source, resourceKey);
        return resourceKey;
    }

    public static ResourceKey<DamageType> getSorceryType(Source source) {
        return SORCERY_MAP.get(source);
    }

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.m_255272_(BLEEDING, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "bleeding"), 0.1f));
        context.m_255272_(BLOOD_ROSE, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "blood_rose"), 0.1f));
        context.m_255272_(HELLISH_CHAIN, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "hellish_chain"), 0.0f));
        context.m_255272_(SORCERY_EARTH, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_earth"), 0.0f));
        context.m_255272_(SORCERY_SEA, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_sea"), 0.0f));
        context.m_255272_(SORCERY_SKY, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_sky"), 0.0f));
        context.m_255272_(SORCERY_SUN, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_sun"), 0.0f));
        context.m_255272_(SORCERY_MOON, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_moon"), 0.0f));
        context.m_255272_(SORCERY_BLOOD, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_blood"), 0.0f));
        context.m_255272_(SORCERY_INFERNAL, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_infernal"), 0.0f));
        context.m_255272_(SORCERY_VOID, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_void"), 0.0f));
        context.m_255272_(SORCERY_HALLOWED, (Object)new DamageType(String.join((CharSequence)".", "primalmagick", "sorcery_hallowed"), 0.0f));
    }
}

