/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class LongDistanceRangedAttack<E extends Mob>
extends Behavior<E> {
    protected final int cooldownBetweenAttacks;
    protected final float minDistanceSq;
    protected final float maxDistanceSq;
    protected final float maxDistance;

    public LongDistanceRangedAttack(int cooldownBetweenAttacks, float minDistance, float maxDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
        this.minDistanceSq = minDistance * minDistance;
        this.maxDistanceSq = maxDistance * maxDistance;
        this.maxDistance = maxDistance;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget((Mob)pEntity);
        BehaviorUtils.m_22595_(pEntity, (LivingEntity)livingentity);
        float distSqr = (float)pEntity.m_20280_((Entity)livingentity);
        float f = Mth.m_14116_((float)distSqr) / this.maxDistance;
        ((RangedAttackMob)pEntity).m_6504_(livingentity, Mth.m_14036_((float)f, (float)0.1f, (float)1.0f));
        pEntity.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)this.cooldownBetweenAttacks);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        LivingEntity livingentity = this.getAttackTarget((Mob)pOwner);
        double distSqr = pOwner.m_20280_((Entity)livingentity);
        return BehaviorUtils.m_22667_(pOwner, (LivingEntity)livingentity) && distSqr > (double)this.minDistanceSq && distSqr <= (double)this.maxDistanceSq;
    }

    private LivingEntity getAttackTarget(Mob mob) {
        return (LivingEntity)mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
    }
}

