/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowCompanionOwnerGoal
extends Goal {
    protected final AbstractCompanionEntity entity;
    protected Player owner;
    protected final LevelReader world;
    protected final double followSpeed;
    protected final PathNavigation navigator;
    protected int timeToRecalcPath;
    protected final float maxDist;
    protected final float minDist;
    protected float oldWaterCost;
    protected final boolean teleportToLeaves;

    public FollowCompanionOwnerGoal(AbstractCompanionEntity entity, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.entity = entity;
        this.world = entity.m_9236_();
        this.followSpeed = speed;
        this.navigator = entity.m_21573_();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(this.navigator instanceof GroundPathNavigation) && !(this.navigator instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowCompanionOwnerGoal");
        }
    }

    public boolean m_8036_() {
        Player owner = this.entity.getCompanionOwner();
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.entity.isCompanionStaying()) {
            return false;
        }
        if (this.entity.m_20280_((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigator.m_26571_()) {
            return false;
        }
        if (this.entity.isCompanionStaying()) {
            return false;
        }
        return !(this.entity.m_20280_((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.entity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.entity.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.entity.m_21523_() && !this.entity.m_20159_()) {
                if (this.entity.m_20280_((Entity)this.owner) >= 324.0) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.m_5624_((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    protected void tryToTeleportNearEntity() {
        BlockPos pos = this.owner.m_20183_();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int dx = this.getRandomNumber(-2, 2);
            int dy = this.getRandomNumber(-1, 1);
            int dz = this.getRandomNumber(-2, 2);
            if (!this.tryToTeleportToLocation(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz)) continue;
            return;
        }
    }

    protected boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.entity.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.entity.m_146908_(), this.entity.m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    protected boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (type != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.entity.m_20183_());
        return this.world.m_45756_((Entity)this.entity, this.entity.m_20191_().m_82338_(blockpos));
    }

    protected int getRandomNumber(int min, int max) {
        return this.entity.m_217043_().m_188503_(max - min + 1) + min;
    }
}

