/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.tags.BlockTagsPM;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class NearestValidFertilizableBlockSensor
extends Sensor<PathfinderMob> {
    private static final int SCAN_RATE = 40;
    private static final int SCAN_XZ_RADIUS = 4;
    private static final int SCAN_Y_RADIUS = 2;

    public NearestValidFertilizableBlockSensor() {
        super(40);
    }

    protected void doTick(ServerLevel pLevel, PathfinderMob pEntity) {
        BlockPos blockPos = pEntity.m_20183_();
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        for (int x = -4; x <= 4; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BonemealableBlock bonemealable;
                    BlockPos scanPos = blockPos.m_7918_(x, y, z);
                    BlockState scanState = pLevel.m_8055_(scanPos);
                    Block block = scanState.m_60734_();
                    if (!(block instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)pLevel, scanPos, scanState, pLevel.f_46443_) || scanState.m_204336_(BlockTagsPM.TREEFOLK_FERTILIZE_EXEMPT)) continue;
                    nearby.add(scanPos);
                }
            }
        }
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)blockPos).m_123331_(arg_0)));
        Brain brain = pEntity.m_6274_();
        if (!nearby.isEmpty()) {
            brain.m_21879_((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get(), nearby);
        } else {
            brain.m_21936_((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get());
        }
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()));
    }
}

