/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public abstract class AbstractCompanionEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected boolean staying;

    protected AbstractCompanionEntity(EntityType<? extends AbstractCompanionEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CompanionStaying", this.isCompanionStaying());
        if (this.hasCompanionOwner()) {
            compound.m_128362_("CompanionOwner", this.getCompanionOwnerId());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCompanionStaying(compound.m_128471_("CompanionStaying"));
        if (compound.m_128403_("CompanionOwner")) {
            this.setCompanionOwnerId(compound.m_128342_("CompanionOwner"));
        } else {
            this.setCompanionOwnerId(null);
        }
    }

    @Nullable
    public UUID getCompanionOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setCompanionOwnerId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public Player getCompanionOwner() {
        try {
            UUID ownerId = this.getCompanionOwnerId();
            return ownerId == null ? null : this.m_9236_().m_46003_(ownerId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean hasCompanionOwner() {
        return this.getCompanionOwnerId() != null;
    }

    public boolean isCompanionOwner(LivingEntity entity) {
        return entity instanceof Player && (Player)entity == this.getCompanionOwner();
    }

    public Team m_5647_() {
        Player owner;
        if (this.hasCompanionOwner() && (owner = this.getCompanionOwner()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity other) {
        if (this.hasCompanionOwner()) {
            Player owner = this.getCompanionOwner();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                return owner.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public boolean isCompanionStaying() {
        return this.staying;
    }

    public void setCompanionStaying(boolean stay) {
        this.staying = stay;
    }

    public boolean shouldAttackEntity(LivingEntity target, Player owner) {
        if (target instanceof AbstractCompanionEntity) {
            AbstractCompanionEntity otherCompanion = (AbstractCompanionEntity)target;
            return !otherCompanion.hasCompanionOwner() || otherCompanion.getCompanionOwner() != owner;
        }
        if (target instanceof Player && !owner.m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    public abstract IPlayerCompanions.CompanionType getCompanionType();

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.hasCompanionOwner()) {
            CompanionManager.removeCompanion(this.getCompanionOwner(), this);
        }
        super.m_142687_(reason);
    }

    public void m_6667_(DamageSource cause) {
        Level level = this.m_9236_();
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46142_) && this.getCompanionOwner() instanceof ServerPlayer) {
            this.getCompanionOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(cause);
    }

    public void m_8119_() {
        Player owner;
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.f_19797_ % 100 == 0 && (owner = this.getCompanionOwner()) != null && !CompanionManager.isCurrentCompanion(owner, this)) {
            this.setCompanionOwnerId(null);
            this.m_6074_();
        }
    }
}

