/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CompanionManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.m_20148_());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.m_20148_());
        }
    }

    public static void addCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player != null && companion != null) {
            companion.setCompanionOwnerId(player.m_20148_());
            IPlayerCompanions companions = PrimalMagickCapabilities.getCompanions(player);
            if (companions != null) {
                Object object;
                UUID oldCompanion = companions.add(companion.getCompanionType(), companion.m_20148_());
                if (oldCompanion != null && (object = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)object;
                    for (ServerLevel serverWorld : serverLevel.m_7654_().m_129785_()) {
                        Entity entity = serverWorld.m_8791_(oldCompanion);
                        if (entity == null) continue;
                        entity.m_6074_();
                        break;
                    }
                }
                CompanionManager.scheduleSync(player);
            }
        }
    }

    public static void removeCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player != null && companion != null) {
            companion.setCompanionOwnerId(null);
            IPlayerCompanions companions = PrimalMagickCapabilities.getCompanions(player);
            if (companions != null && companions.remove(companion.getCompanionType(), companion.m_20148_())) {
                CompanionManager.scheduleSync(player);
            }
        }
    }

    public static boolean isCurrentCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player == null || companion == null) {
            return false;
        }
        IPlayerCompanions companions = PrimalMagickCapabilities.getCompanions(player);
        return companions != null && companions.contains(companion.getCompanionType(), companion.m_20148_());
    }
}

