/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions.golems;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtByTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionStayGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.FollowCompanionOwnerGoal;
import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEnchantedGolemEntity
extends AbstractCompanionEntity
implements NeutralMob {
    protected static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(AbstractEnchantedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    protected int attackTimer;
    protected UUID angerTarget;
    protected long lastStayChangeTime;

    public AbstractEnchantedGolemEntity(EntityType<? extends AbstractEnchantedGolemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        Level level = this.m_9236_();
        super.m_7378_(compound);
        if (!level.f_46443_) {
            this.m_147285_((Level)((ServerLevel)level), compound);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CompanionStayGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(6, (Goal)new FollowCompanionOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new CompanionOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractEnchantedGolemEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
        if (entityIn instanceof Enemy && !(entityIn instanceof Creeper) && this.m_217043_().m_188503_(20) == 0) {
            this.m_6710_((LivingEntity)entityIn);
        }
        super.m_7324_(entityIn);
    }

    public void m_8107_() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        boolean isAir;
        super.m_8107_();
        Level level = this.m_9236_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0 && !(isAir = (blockstate = level.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_())) {
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
        }
        if (!level.f_46443_) {
            this.m_21666_((ServerLevel)level, true);
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.isCompanionOwner(target) ? false : super.m_6779_(target);
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, Player owner) {
        if (target instanceof Creeper) {
            return false;
        }
        return super.shouldAttackEntity(target, owner);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    @Override
    public IPlayerCompanions.CompanionType getCompanionType() {
        return IPlayerCompanions.CompanionType.GOLEM;
    }

    public Cracks getCrackLevel() {
        return Cracks.getForHealthPercentage(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Cracks cracksBefore = this.getCrackLevel();
        boolean success = super.m_6469_(source, amount);
        if (success && cracksBefore != this.getCrackLevel()) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return success;
    }

    public boolean m_7327_(Entity entityIn) {
        this.attackTimer = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float rawDamage = (float)this.m_21133_(Attributes.f_22281_);
        float damage = (int)rawDamage > 0 ? rawDamage / 2.0f + (float)this.f_19796_.m_188503_((int)rawDamage) : rawDamage;
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage);
        if (flag) {
            entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, 0.4, 0.0));
            this.m_19970_((LivingEntity)this, entityIn);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected abstract TagKey<Item> getRepairMaterialTag();

    protected abstract float getRepairHealAmount();

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        Level level = this.m_9236_();
        ItemStack itemstack = playerIn.m_21120_(hand);
        if (!itemstack.m_204117_(this.getRepairMaterialTag())) {
            InteractionResult actionResult = super.m_6071_(playerIn, hand);
            if (!actionResult.m_19077_() && this.isCompanionOwner((LivingEntity)playerIn) && !level.f_46443_) {
                long time = playerIn.m_9236_().m_46467_();
                if (this.lastStayChangeTime != time) {
                    this.setCompanionStaying(!this.isCompanionStaying());
                    if (this.isCompanionStaying()) {
                        playerIn.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.golem.stay"));
                    } else {
                        playerIn.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.golem.follow"));
                    }
                    this.lastStayChangeTime = time;
                }
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        float healthBefore = this.m_21223_();
        this.m_5634_(this.getRepairHealAmount());
        if (this.m_21223_() == healthBefore) {
            return InteractionResult.PASS;
        }
        this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        if (!playerIn.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public boolean m_6914_(LevelReader worldIn) {
        BlockPos downPos = this.m_20183_().m_7495_();
        BlockState downState = worldIn.m_8055_(downPos);
        if (!downState.m_60634_((BlockGetter)worldIn, downPos, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState upState;
            BlockPos upPos = this.m_20183_().m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)upPos, (BlockState)(upState = worldIn.m_8055_(upPos)), (FluidState)upState.m_60819_(), (EntityType)this.m_6095_())) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)this.m_20183_(), (BlockState)worldIn.m_8055_(this.m_20183_()), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)this.m_6095_()) && worldIn.m_45784_((Entity)this);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        MobEffect effect = potioneffectIn.m_19544_();
        return effect == MobEffects.f_19614_ || effect == EffectsPM.BLEEDING.get() ? false : super.m_7301_(potioneffectIn);
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> SORTED_VALUES;
        private final float healthPercentage;

        private Cracks(float healthPercentage) {
            this.healthPercentage = healthPercentage;
        }

        public static Cracks getForHealthPercentage(float percentage) {
            for (Cracks cracks : SORTED_VALUES) {
                if (!(percentage < cracks.healthPercentage)) continue;
                return cracks;
            }
            return NONE;
        }

        static {
            SORTED_VALUES = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(c -> c.healthPercentage)).collect(ImmutableList.toImmutableList());
        }
    }
}

