/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions.pixies;

import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtByTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.ZoomAtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.companions.pixies.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.FlameDamageSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.BoltSpellVehicle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public abstract class AbstractInfernalPixieEntity
extends AbstractPixieEntity {
    public AbstractInfernalPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected Source getPixieSource() {
        return Source.INFERNAL;
    }

    @Override
    protected SpellPackage createSpellPackage() {
        SpellPackage spell = new SpellPackage("Pixie Bolt");
        BoltSpellVehicle vehicle = new BoltSpellVehicle();
        vehicle.getProperty("range").setValue(5);
        spell.setVehicle(vehicle);
        FlameDamageSpellPayload payload = new FlameDamageSpellPayload();
        payload.getProperty("power").setValue(this.getSpellPower());
        payload.getProperty("duration").setValue(this.getSpellPower());
        spell.setPayload(payload);
        return spell;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ExplodeOnTargetGoal(this, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new ZoomAtTargetGoal((Mob)this, 2.0f, 8.0f, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.f_21346_.m_25352_(1, (Goal)new CompanionOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractInfernalPixieEntity)this).m_21674_(arg_0)));
    }

    public void explode() {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            Explosion explosion = level.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.getSpellPower(), true, Level.ExplosionInteraction.TNT);
            this.m_6469_(this.m_9236_().m_269111_().m_269093_(explosion), Float.MAX_VALUE);
        }
    }

    public static class ExplodeOnTargetGoal
    extends Goal {
        protected final AbstractInfernalPixieEntity pixie;
        protected final float maxRangeSq;

        public ExplodeOnTargetGoal(AbstractInfernalPixieEntity pixie, float maxRange) {
            this.pixie = pixie;
            this.maxRangeSq = maxRange * maxRange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.pixie.m_5448_();
            return target != null && this.pixie.m_20280_((Entity)target) <= (double)this.maxRangeSq;
        }

        public void m_8056_() {
            this.pixie.explode();
        }
    }
}

