/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions.pixies;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.entities.ai.goals.FollowCompanionOwnerGoal;
import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.entities.companions.pixies.IPixie;
import com.verdantartifice.primalmagick.common.items.misc.PixieItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPixieEntity
extends AbstractCompanionEntity
implements NeutralMob,
FlyingAnimal,
IPixie {
    protected static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(AbstractPixieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    protected int attackTimer;
    protected UUID angerTarget;
    protected SpellPackage spellCache;

    public AbstractPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
    }

    @Nonnull
    protected abstract Source getPixieSource();

    @Nonnull
    protected abstract PixieItem getSpawnItem();

    @Nonnull
    protected abstract SpellPackage createSpellPackage();

    @Nonnull
    protected SpellPackage getSpellPackage() {
        if (this.spellCache == null) {
            this.spellCache = this.createSpellPackage();
        }
        return this.spellCache;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.m_147285_((Level)((ServerLevel)level), compound);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new FollowCompanionOwnerGoal(this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(6, (Goal)new RandomFlyGoal(this, 16.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.m_21666_((ServerLevel)level, true);
            if (this.m_6084_()) {
                level.m_7605_((Entity)this, (byte)15);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    public void m_7822_(byte id) {
        if (id == 15) {
            FxDispatcher.INSTANCE.pixieDust(this.m_20185_() + this.f_19796_.m_188583_() * 0.25, this.m_20186_() + 0.25, this.m_20189_() + this.f_19796_.m_188583_() * 0.25, this.getPixieSource().getColor());
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return this.isCompanionOwner(target) ? false : super.m_6779_(target);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    @Override
    public IPlayerCompanions.CompanionType getCompanionType() {
        return IPlayerCompanions.CompanionType.PIXIE;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11733_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11732_;
    }

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        InteractionResult actionResult = super.m_6071_(playerIn, hand);
        if (!actionResult.m_19077_() && !this.m_9236_().f_46443_ && this.isCompanionOwner((LivingEntity)playerIn)) {
            ItemStack stack;
            ItemStack held = playerIn.m_21120_(hand);
            if (ItemStack.m_41656_((ItemStack)held, (ItemStack)(stack = new ItemStack((ItemLike)this.getSpawnItem())))) {
                held.m_41769_(1);
            } else if (held.m_41619_()) {
                playerIn.m_21008_(hand, stack);
            } else {
                return InteractionResult.FAIL;
            }
            CompanionManager.removeCompanion(this.getCompanionOwner(), this);
            this.m_5496_(this.m_7975_(null), 1.0f, 1.0f);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return actionResult;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, worldIn);
        nav.m_26440_(false);
        nav.m_26443_(true);
        return nav;
    }

    protected static class RandomFlyGoal
    extends Goal {
        protected final AbstractPixieEntity pixie;
        protected final PathNavigation navigator;
        protected final float wanderDistance;
        protected int timeToRecalcPath;

        public RandomFlyGoal(AbstractPixieEntity pixie, float wanderDistance) {
            this.pixie = pixie;
            this.navigator = this.pixie.m_21573_();
            this.wanderDistance = wanderDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double dz;
            double dy;
            MoveControl movementcontroller = this.pixie.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double dx = movementcontroller.m_25000_() - this.pixie.m_20185_();
            double dist = dx * dx + (dy = movementcontroller.m_25001_() - this.pixie.m_20186_()) * dy + (dz = movementcontroller.m_25002_() - this.pixie.m_20189_()) * dz;
            return dist < 1.0 || dist > 3600.0;
        }

        public boolean m_8045_() {
            return this.timeToRecalcPath > 0;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 40;
                RandomSource random = this.pixie.m_217043_();
                double d0 = this.pixie.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * this.wanderDistance);
                double d1 = this.pixie.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 2.0f);
                double d2 = this.pixie.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * this.wanderDistance);
                this.navigator.m_26519_(d0, d1, d2, 1.0);
            }
        }
    }
}

