/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions.pixies;

import com.verdantartifice.primalmagick.common.entities.companions.pixies.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.HealingSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.BoltSpellVehicle;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class AbstractSunPixieEntity
extends AbstractPixieEntity {
    public AbstractSunPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected Source getPixieSource() {
        return Source.SUN;
    }

    @Override
    protected SpellPackage createSpellPackage() {
        SpellPackage spell = new SpellPackage("Pixie Bolt");
        BoltSpellVehicle vehicle = new BoltSpellVehicle();
        vehicle.getProperty("range").setValue(5);
        spell.setVehicle(vehicle);
        HealingSpellPayload payload = new HealingSpellPayload();
        payload.getProperty("power").setValue(this.getSpellPower());
        spell.setPayload(payload);
        return spell;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new HealOwnerGoal(this, 1.0, 20, 30, 16.0f));
    }

    public void castSpell() {
        this.getSpellPackage().cast(this.m_9236_(), (LivingEntity)this, null);
    }

    protected static class HealOwnerGoal
    extends Goal {
        protected final AbstractSunPixieEntity pixie;
        protected final double moveSpeed;
        protected final int castIntervalMin;
        protected final int castIntervalMax;
        protected final float castRadius;
        protected final float maxCastDistanceSq;
        protected LivingEntity castTarget;
        protected int seeTime;
        protected int castTime = -1;

        public HealOwnerGoal(AbstractSunPixieEntity pixie, double moveSpeed, int minCastTime, int maxCastTime, float maxCastDistance) {
            this.pixie = pixie;
            this.moveSpeed = moveSpeed;
            this.castIntervalMin = minCastTime;
            this.castIntervalMax = maxCastTime;
            this.castRadius = maxCastDistance;
            this.maxCastDistanceSq = maxCastDistance * maxCastDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            Player target = this.pixie.getCompanionOwner();
            if (target != null && target.m_6084_() && target.m_21223_() / target.m_21233_() < 0.75f) {
                this.castTarget = target;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.pixie.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.castTarget = null;
            this.seeTime = 0;
            this.castTime = -1;
        }

        public void m_8037_() {
            float distSq = (float)this.pixie.m_20280_((Entity)this.castTarget);
            boolean canSee = this.pixie.m_21574_().m_148306_((Entity)this.castTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (distSq <= this.maxCastDistanceSq && this.seeTime >= 5) {
                this.pixie.m_21573_().m_26573_();
            } else {
                this.pixie.m_21573_().m_5624_((Entity)this.castTarget, this.moveSpeed);
            }
            this.pixie.m_21563_().m_24960_((Entity)this.castTarget, 30.0f, 30.0f);
            if (--this.castTime == 0) {
                if (!canSee) {
                    return;
                }
                float f = Mth.m_14116_((float)distSq) / this.castRadius;
                this.pixie.castSpell();
                this.castTime = Mth.m_14143_((float)(f * (float)(this.castIntervalMax - this.castIntervalMin) + (float)this.castIntervalMin));
            } else if (this.castTime < 0) {
                float f = Mth.m_14116_((float)distSq) / this.castRadius;
                this.castTime = Mth.m_14143_((float)(f * (float)(this.castIntervalMax - this.castIntervalMin) + (float)this.castIntervalMin));
            }
        }
    }
}

