/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.entities.FlyingCarpetItem;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FlyingCarpetEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DYE_COLOR = SynchedEntityData.m_135353_(FlyingCarpetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FlyingCarpetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float momentum;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean forwardInputDown;
    private boolean backInputDown;

    public FlyingCarpetEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19850_ = true;
        this.m_20242_(true);
    }

    public FlyingCarpetEntity(Level worldIn, double x, double y, double z) {
        this((EntityType)EntityTypesPM.FLYING_CARPET.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public FlyingCarpetEntity(Level worldIn, BlockPos pos) {
        this(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_7337_(Entity entity) {
        return (entity.m_5829_() || entity.m_6094_()) && !this.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle result) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, result));
    }

    public double m_6048_() {
        return -0.1;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        Level level = this.m_9236_();
        if (this.m_20160_() && this.m_6109_()) {
            this.updateMotion();
            if (level.f_46443_) {
                this.controlCarpet();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
            if (level.f_46443_) {
                this.updateInputs(false, false);
            }
        }
        this.m_20101_();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double newX = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double newY = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double newZ = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double deltaYaw = Mth.m_14175_((double)(this.lerpYaw - (double)this.m_146908_()));
            float yRot = (float)((double)this.m_146908_() + deltaYaw / (double)this.lerpSteps);
            float xRot = (float)((double)this.m_146909_() + (this.lerpPitch - (double)this.m_146909_()) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(newX, newY, newZ);
            this.m_19915_(yRot, xRot);
        }
    }

    private void updateMotion() {
        this.momentum = 0.9f;
        this.m_20256_(this.m_20184_().m_82490_((double)this.momentum).m_82520_(0.0, this.m_20068_() ? 0.0 : -0.04, 0.0));
    }

    private void controlCarpet() {
        if (this.m_20160_()) {
            LivingEntity pilot = this.m_6688_();
            this.f_19859_ = this.m_146908_();
            this.m_146922_(pilot.m_146908_());
            float f = 0.0f;
            if (this.forwardInputDown) {
                f += 0.03f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            Vec3 newMotion = this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), (double)(Mth.m_14031_((float)(-pilot.m_146909_() * ((float)Math.PI / 180))) * f), (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f));
            this.m_20256_(newMotion);
        }
    }

    public void updateInputs(boolean forwardDown, boolean backwardDown) {
        this.forwardInputDown = forwardDown;
        this.backInputDown = backwardDown;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public void m_7340_(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.m_6084_()) {
            if (player.m_36341_()) {
                this.m_5552_(this.getDropItem(), 0.0f);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        block5: {
            level = this.m_9236_();
            if (this.m_6673_(pSource)) {
                return false;
            }
            if (level.f_46443_ || this.m_213877_()) break block5;
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            var6_4 = pSource.m_7639_();
            if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var6_4;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamage() > 40.0f) {
                if (level.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_5552_(this.getDropItem(), 0.0f);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    protected ItemStack getDropItem() {
        ItemStack stack = new ItemStack((ItemLike)ItemsPM.FLYING_CARPET.get());
        DyeColor color = this.getDyeColor();
        if (color != null) {
            ((FlyingCarpetItem)stack.m_41720_()).setDyeColor(stack, color);
        }
        return stack;
    }

    public DyeColor getDyeColor() {
        int value = (Integer)this.f_19804_.m_135370_(DYE_COLOR);
        if (value == -1) {
            return null;
        }
        return DyeColor.m_41053_((int)value);
    }

    public void setDyeColor(DyeColor color) {
        if (color == null) {
            this.f_19804_.m_135381_(DYE_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(DYE_COLOR, (Object)color.m_41060_());
        }
    }

    public void setDamage(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_19789_ = 0.0f;
        if (this.m_20160_()) {
            this.m_6688_().f_19789_ = 0.0f;
        }
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }
}

