/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BasicItemListing;

public class FriendlyWitchEntity
extends AbstractVillager
implements NeutralMob,
RangedAttackMob {
    public static final String HONORED_NAME = "Corspilla";
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("6171c72b-f71a-46cd-8afb-d199d159ad56");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.m_135353_(FriendlyWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(FriendlyWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private static final List<VillagerTrades.ItemListing> TRADE_LISTINGS = (List)Util.m_137469_(new ArrayList(), list -> {
        list.add(new BasicItemListing(1, new ItemStack((ItemLike)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get()), 12, 5, 0.05f));
        list.add(new BasicItemListing(4, new ItemStack((ItemLike)ItemsPM.BLOOD_NOTES.get()), 12, 5, 0.05f));
        list.add(new BasicItemListing(8, new ItemStack((ItemLike)ItemsPM.SHEEP_TOME.get()), 12, 5, 0.05f));
    });
    protected UUID angerTarget;
    private int usingTime;

    public FriendlyWitchEntity(EntityType<? extends FriendlyWitchEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((FriendlyWitchEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_USING_ITEM, (Object)false);
        this.m_20088_().m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_146762_(Math.max(0, this.m_146764_()));
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.m_147285_((Level)((ServerLevel)level), tag);
        }
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void setUsingItem(boolean use) {
        this.m_20088_().m_135381_(DATA_USING_ITEM, (Object)use);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.m_20088_().m_135370_(DATA_USING_ITEM);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (!this.isDrinkingPotion()) {
            Vec3 movement = target.m_20184_();
            double dx = target.m_20185_() + movement.f_82479_ - this.m_20185_();
            double dy = target.m_20188_() - (double)1.1f - this.m_20186_();
            double dz = target.m_20189_() + movement.f_82481_ - this.m_20189_();
            double dist = Math.sqrt(dx * dx + dz * dz);
            Potion potion = Potions.f_43582_;
            if (dist >= 8.0 && !target.m_21023_(MobEffects.f_19597_)) {
                potion = Potions.f_43615_;
            } else if (target.m_21223_() >= 8.0f && !target.m_21023_(MobEffects.f_19614_)) {
                potion = Potions.f_43584_;
            } else if (dist <= 3.0 && !target.m_21023_(MobEffects.f_19613_) && this.f_19796_.m_188501_() < 0.25f) {
                potion = Potions.f_43593_;
            }
            Level level = this.m_9236_();
            ThrownPotion thrownpotion = new ThrownPotion(level, (LivingEntity)this);
            thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
            thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
            thrownpotion.m_6686_(dx, dy + dist * 0.2, dz, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            level.m_7967_((Entity)thrownpotion);
        }
    }

    protected void m_8058_(MerchantOffer offer) {
        Level level = this.m_9236_();
        if (offer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            level.m_7967_((Entity)new ExperienceOrb(level, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected void m_7604_() {
        MerchantOffers offers = this.m_6616_();
        for (VillagerTrades.ItemListing listing : TRADE_LISTINGS) {
            MerchantOffer offer = listing.m_213663_((Entity)this, this.m_217043_());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        Level level = this.m_9236_();
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6785_(double distSq) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12549_;
    }

    public void m_7713_(ItemStack stack) {
    }

    public void m_8107_() {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.m_6084_()) {
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    List list;
                    this.setUsingItem(false);
                    ItemStack stack = this.m_21205_();
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (stack.m_150930_(Items.f_42589_) && (list = PotionUtils.m_43547_((ItemStack)stack)) != null) {
                        for (MobEffectInstance effectInstance : list) {
                            this.m_7292_(new MobEffectInstance(effectInstance));
                        }
                    }
                    this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
                }
            } else {
                Potion potion = null;
                if (this.f_19796_.m_188501_() < 0.15f && this.m_204029_(FluidTags.f_13131_) && !this.m_21023_(MobEffects.f_19608_)) {
                    potion = Potions.f_43621_;
                } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
                    potion = Potions.f_43610_;
                } else if (this.f_19796_.m_188501_() < 0.05f && this.m_21223_() < this.m_21233_()) {
                    potion = Potions.f_43623_;
                } else if (this.f_19796_.m_188501_() < 0.5f && this.m_5448_() != null && !this.m_21023_(MobEffects.f_19596_) && this.m_5448_().m_20280_((Entity)this) > 121.0) {
                    potion = Potions.f_43612_;
                }
                if (potion != null) {
                    this.m_8061_(EquipmentSlot.MAINHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion));
                    this.usingTime = this.m_21205_().m_41779_();
                    this.setUsingItem(true);
                    if (!this.m_20067_()) {
                        level.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    AttributeInstance attr = this.m_21051_(Attributes.f_22279_);
                    attr.m_22130_(SPEED_MODIFIER_DRINKING);
                    attr.m_22118_(SPEED_MODIFIER_DRINKING);
                }
            }
            if (this.f_19796_.m_188501_() < 7.5E-4f) {
                level.m_7605_((Entity)this, (byte)15);
            }
        }
        super.m_8107_();
    }

    public void m_7822_(byte val) {
        if (val == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(val);
        }
    }

    protected float m_6515_(DamageSource source, float damage) {
        damage = super.m_6515_(source, damage);
        if (source.m_7639_() == this) {
            damage = 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268731_)) {
            damage *= 0.15f;
        }
        return damage;
    }

    public int m_6784_() {
        return (Integer)this.m_20088_().m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.m_20088_().m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }
}

