/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.ai.goals.LongDistanceRangedAttackGoal;
import com.verdantartifice.primalmagick.common.entities.misc.SinCrystalEntity;
import com.verdantartifice.primalmagick.common.entities.projectiles.SinCrashEntity;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.BloodDamageSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.ProjectileSpellVehicle;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class InnerDemonEntity
extends Monster
implements RangedAttackMob,
PowerableMob {
    public static final double HEAL_RANGE = 16.0;
    protected static final double SIN_CRASH_RANGE = 12.0;
    protected final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    protected boolean isSuffocating = false;
    protected List<SinCrystalEntity> crystalsInRange = new ArrayList<SinCrystalEntity>();

    public InnerDemonEntity(EntityType<? extends InnerDemonEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21573_().m_7008_(true);
        this.f_21364_ = 50;
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 1.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SinCrashGoal(this, 100, 600));
        this.f_21345_.m_25352_(3, new LongDistanceRangedAttackGoal<InnerDemonEntity>(this, 1.0, 30, 4.0f, 16.0f, true));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, null));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    @Nonnull
    protected SpellPackage getSpellPackage() {
        SpellPackage spell = new SpellPackage("Blood Ball");
        ProjectileSpellVehicle vehicle = new ProjectileSpellVehicle();
        spell.setVehicle(vehicle);
        BloodDamageSpellPayload payload = new BloodDamageSpellPayload();
        Difficulty difficulty = this.m_9236_().m_46791_();
        payload.getProperty("power").setValue(difficulty == Difficulty.EASY ? 1 : (difficulty == Difficulty.HARD ? 5 : 3));
        spell.setPayload(payload);
        return spell;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.getSpellPackage().cast(this.m_9236_(), (LivingEntity)this, null);
    }

    public boolean m_7090_() {
        return true;
    }

    public void m_8107_() {
        Level level = this.m_9236_();
        this.crystalsInRange = EntityUtils.getEntitiesInRange(level, this.m_20182_(), null, SinCrystalEntity.class, 16.0);
        if (!this.crystalsInRange.isEmpty() && this.f_19797_ % 10 == 0 && !level.f_46443_) {
            this.m_5634_(this.crystalsInRange.size());
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            if (this.isSuffocating && this.f_19797_ % 20 == 0) {
                Level.ExplosionInteraction mode = ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                level.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 7.0f, false, mode);
                this.isSuffocating = false;
            }
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean retVal = super.m_7327_(entityIn);
        entityIn.m_20254_(5);
        return retVal;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_9236_().m_269111_().m_269063_() || source.m_7639_() instanceof InnerDemonEntity) {
            return false;
        }
        if (source == this.m_9236_().m_269111_().m_269318_()) {
            this.isSuffocating = true;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        ItemEntity itemEntity = this.m_19998_((ItemLike)ItemsPM.HALLOWED_ORB.get());
        if (itemEntity != null) {
            itemEntity.m_32064_();
        }
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @Nonnull
    public List<SinCrystalEntity> getCrystalsInRange() {
        return Collections.unmodifiableList(this.crystalsInRange);
    }

    public void doSinCrash() {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            double demonPosX = this.m_20185_();
            double demonPosY = this.m_20188_();
            double demonPosZ = this.m_20189_();
            Difficulty difficulty = level.m_46791_();
            int crashCount = difficulty == Difficulty.EASY ? 1 : (difficulty == Difficulty.HARD ? 3 : 2);
            for (int index = 0; index < crashCount; ++index) {
                double dx = level.f_46441_.m_188583_() * 12.0 * (level.f_46441_.m_188499_() ? 1.0 : -1.0);
                double dy = -1.0 * (double)this.m_20192_();
                double dz = level.f_46441_.m_188583_() * 12.0 * (level.f_46441_.m_188499_() ? 1.0 : -1.0);
                SinCrashEntity crash = new SinCrashEntity(level, (LivingEntity)this, dx, dy, dz);
                crash.m_7678_(demonPosX, demonPosY, demonPosZ, 0.0f, 0.0f);
                level.m_7967_((Entity)crash);
            }
            level.m_6263_(null, demonPosX, demonPosY, demonPosZ, (SoundEvent)SoundsPM.WHISPERS.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public static class SinCrashGoal
    extends Goal {
        protected final InnerDemonEntity demon;
        protected final int startDelayTicks;
        protected final int cooldownTicks;
        protected int timer = -1;

        public SinCrashGoal(InnerDemonEntity demon, int startDelayTicks, int cooldownTicks) {
            this.demon = demon;
            this.startDelayTicks = startDelayTicks;
            this.cooldownTicks = cooldownTicks;
            this.timer = this.startDelayTicks;
        }

        public boolean m_8036_() {
            LivingEntity target = this.demon.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            this.timer = this.startDelayTicks;
        }

        public void m_8037_() {
            if (--this.timer == 0) {
                this.demon.doSinCrash();
                this.timer = this.cooldownTicks;
            } else if (this.timer < 0) {
                this.timer = this.cooldownTicks;
            }
        }
    }
}

