/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.misc.InnerDemonEntity;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class SinCrystalEntity
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> BEAM_TARGET = SynchedEntityData.m_135353_(SinCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<UUID>> DAMAGE_CLOUD = SynchedEntityData.m_135353_(SinCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public int innerRotation;

    public SinCrystalEntity(EntityType<? extends SinCrystalEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19850_ = true;
        this.innerRotation = this.f_19796_.m_188503_(100000);
    }

    public SinCrystalEntity(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends SinCrystalEntity>)((EntityType)EntityTypesPM.SIN_CRYSTAL.get()), worldIn);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BEAM_TARGET, Optional.empty());
        this.m_20088_().m_135372_(DAMAGE_CLOUD, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.innerRotation;
        Level level = this.m_9236_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            UUID cloudId = this.getDamageCloud();
            if (cloudId == null) {
                AreaEffectCloud cloud = new AreaEffectCloud(level, this.m_20185_(), this.m_20186_(), this.m_20189_());
                cloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
                cloud.m_19712_(3.0f);
                cloud.m_19734_(5);
                cloud.m_19740_(0);
                cloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
                level.m_7967_((Entity)cloud);
                this.setDamageCloud(cloud.m_20148_());
            } else {
                Entity entity = serverWorld.m_8791_(cloudId);
                if (entity instanceof AreaEffectCloud) {
                    AreaEffectCloud cloud = (AreaEffectCloud)entity;
                    cloud.m_19734_(1 + cloud.m_19748_());
                } else {
                    this.setDamageCloud(null);
                }
            }
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BeamTarget", 10)) {
            this.setBeamTarget(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BeamTarget")));
        }
        if (compound.m_128425_("DamageCloudUUID", 10)) {
            this.setDamageCloud(compound.m_128342_("DamageCloudUUID"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.getBeamTarget() != null) {
            compound.m_128365_("BeamTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.getBeamTarget()));
        }
        if (this.getDamageCloud() != null) {
            compound.m_128362_("DamageCloudUUID", this.getDamageCloud());
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7639_() instanceof InnerDemonEntity) {
            return false;
        }
        Level level = this.m_9236_();
        if (this.m_6084_() && !level.f_46443_) {
            List<InnerDemonEntity> demonsInRange = EntityUtils.getEntitiesInRange(level, this.m_20182_(), null, InnerDemonEntity.class, 16.0);
            if (!demonsInRange.isEmpty()) {
                LivingEntity trueSource = source.m_7639_() instanceof LivingEntity ? (LivingEntity)source.m_7639_() : null;
                for (InnerDemonEntity demon : demonsInRange) {
                    demon.m_6469_(level.m_269111_().m_269036_((Entity)trueSource, null), 10.0f);
                }
            }
            this.m_146870_();
            if (!source.m_269533_(DamageTypeTags.f_268415_)) {
                level.m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.BLOCK);
            }
        }
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.m_20088_().m_135381_(BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.m_20088_().m_135370_(BEAM_TARGET)).orElse(null);
    }

    public void setDamageCloud(@Nullable UUID cloudId) {
        this.m_20088_().m_135381_(DAMAGE_CLOUD, Optional.ofNullable(cloudId));
    }

    @Nullable
    public UUID getDamageCloud() {
        return ((Optional)this.m_20088_().m_135370_(DAMAGE_CLOUD)).orElse(null);
    }

    public boolean m_6783_(double distance) {
        return super.m_6783_(distance) || this.getBeamTarget() != null;
    }
}

