/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractTridentEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(AbstractTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> HAS_GLINT = SynchedEntityData.m_135353_(AbstractTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected ItemStack thrownStack;
    protected boolean dealtDamage;
    public int returningTicks;

    public AbstractTridentEntity(EntityType<? extends AbstractTridentEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractTridentEntity(EntityType<? extends AbstractTridentEntity> type, Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(type, thrower, worldIn);
        this.thrownStack = thrownStackIn.m_41777_();
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.thrownStack)));
        this.f_19804_.m_135381_(HAS_GLINT, (Object)this.thrownStack.m_41790_());
    }

    public AbstractTridentEntity(EntityType<? extends AbstractTridentEntity> type, Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(HAS_GLINT, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.m_19749_();
        Level level = this.m_9236_();
        if ((this.dealtDamage || this.m_36797_()) && shooter != null) {
            byte loyalty = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
            if (loyalty > 0 && !this.shouldReturnToThrower()) {
                if (!level.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (loyalty > 0) {
                this.m_36790_(true);
                Vec3 vector3d = new Vec3(shooter.m_20185_() - this.m_20185_(), shooter.m_20188_() - this.m_20186_(), shooter.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)loyalty, this.m_20189_());
                if (level.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)loyalty;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.m_8119_();
    }

    private boolean shouldReturnToThrower() {
        Entity shooter = this.m_19749_();
        if (shooter != null && shooter.m_6084_()) {
            return !(shooter instanceof ServerPlayer) || !shooter.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.thrownStack.m_41777_();
    }

    public boolean hasGlint() {
        return (Boolean)this.f_19804_.m_135370_(HAS_GLINT);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    public abstract double m_36789_();

    protected void m_5790_(EntityHitResult result) {
        BlockPos pos;
        Entity entity = result.m_82443_();
        float damage = (float)this.m_36789_();
        if (entity instanceof LivingEntity) {
            damage += EnchantmentHelper.m_44833_((ItemStack)this.thrownStack, (MobType)((LivingEntity)entity).m_6336_());
        }
        Entity shooter = this.m_19749_();
        DamageSource damageSource = this.m_9236_().m_269111_().m_269525_((Entity)this, (Entity)(shooter == null ? this : shooter));
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, damage)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (shooter instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)shooter);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)shooter), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float volume = 1.0f;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && level.m_46470_() && EnchantmentHelper.m_44936_((ItemStack)this.thrownStack) && level.m_45527_(pos = entity.m_20183_())) {
            LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            lightningBoltEntity.m_20219_(Vec3.m_82539_((Vec3i)pos));
            lightningBoltEntity.m_20879_(shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null);
            level.m_7967_((Entity)lightningBoltEntity);
            soundEvent = SoundEvents.f_12521_;
            volume = 5.0f;
        }
        this.m_5496_(soundEvent, volume, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player entityIn) {
        Entity shooter = this.m_19749_();
        if (shooter == null || shooter.m_20148_() == entityIn.m_20148_()) {
            super.m_6123_(entityIn);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Trident", 10)) {
            this.thrownStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Trident"));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.thrownStack)));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Trident", (Tag)this.thrownStack.m_41739_(new CompoundTag()));
        compound.m_128379_("DealtDamage", this.dealtDamage);
    }

    protected void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL) <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

