/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PotionExplosionPacket;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class AlchemicalBombEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::m_6126_;

    public AlchemicalBombEntity(EntityType<? extends AlchemicalBombEntity> entityType, Level world) {
        super(entityType, world);
    }

    public AlchemicalBombEntity(Level world, LivingEntity entity) {
        super((EntityType)EntityTypesPM.ALCHEMICAL_BOMB.get(), entity, world);
    }

    public AlchemicalBombEntity(Level world, double x, double y, double z) {
        super((EntityType)EntityTypesPM.ALCHEMICAL_BOMB.get(), x, y, z, world);
    }

    protected Item m_7881_() {
        return (Item)ItemsPM.ALCHEMICAL_BOMB.get();
    }

    protected float m_7139_() {
        return 0.05f;
    }

    public void m_8119_() {
        super.m_8119_();
        FuseType fuse = ConcoctionUtils.getFuseType(this.m_7846_());
        if (fuse != null && fuse.hasTimer() && this.f_19797_ >= fuse.getFuseLength()) {
            this.detonate(null);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        FuseType fuse = ConcoctionUtils.getFuseType(this.m_7846_());
        if (fuse == FuseType.IMPACT) {
            this.detonate(null);
        } else if (fuse != null) {
            double mx = result.m_82434_().m_122429_() == 0 ? 1.0 : -1.0;
            double my = 0.9 * (result.m_82434_().m_122430_() == 0 ? 1.0 : -1.0);
            double mz = result.m_82434_().m_122431_() == 0 ? 1.0 : -1.0;
            this.m_20256_(this.m_20184_().m_82490_(0.7).m_82542_(mx, my, mz));
            Level level = this.m_9236_();
            if (!level.f_46443_) {
                float volume = Mth.m_14036_((float)((float)this.m_20184_().m_82553_()), (float)0.0f, (float)1.0f);
                this.m_5496_((SoundEvent)SoundsPM.CLANK.get(), volume, 0.8f + 0.4f * level.f_46441_.m_188501_());
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.detonate(result.m_82443_());
    }

    private void detonate(@Nullable Entity struckEntity) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            ItemStack itemStack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            List effects = PotionUtils.m_43547_((ItemStack)itemStack);
            PacketHandler.sendToAllAround(new PotionExplosionPacket(this.m_20182_(), PotionUtils.m_43575_((ItemStack)itemStack), potion.m_43491_()), (ResourceKey<Level>)level.m_46472_(), this.m_20183_(), 32.0);
            if (potion == Potions.f_43599_ && effects.isEmpty()) {
                this.applyWater();
            } else if (!effects.isEmpty()) {
                this.applyPotionEffects(effects, struckEntity);
            }
            this.m_146870_();
        }
    }

    private void applyWater() {
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, aabb, WATER_SENSITIVE);
        for (LivingEntity entity : entities) {
            double distanceSq = this.m_20280_((Entity)entity);
            if (!(distanceSq < 16.0) || !entity.m_6126_()) continue;
            entity.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)entity, this.m_19749_()), 1.0f);
        }
        BlockPos pos = this.m_20183_();
        this.extinguishFire(pos);
        for (Direction dir : Direction.values()) {
            this.extinguishFire(pos.m_121945_(dir));
        }
    }

    private void applyPotionEffects(List<MobEffectInstance> effects, @Nullable Entity struckEntity) {
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List entityList = this.m_9236_().m_45976_(LivingEntity.class, aabb);
        for (LivingEntity entity : entityList) {
            double distanceSq;
            if (!entity.m_5801_() || !((distanceSq = this.m_20280_((Entity)entity)) < 16.0)) continue;
            double multiplier = entity == struckEntity ? 1.0 : 1.0 - Math.sqrt(distanceSq) / 4.0;
            for (MobEffectInstance effectInstance : effects) {
                MobEffect effect = effectInstance.m_19544_();
                if (effect.m_8093_()) {
                    effect.m_19461_((Entity)this, this.m_19749_(), entity, effectInstance.m_19564_(), multiplier);
                    continue;
                }
                int scaledDuration = (int)(multiplier * (double)effectInstance.m_19557_() + 0.5);
                if (scaledDuration <= 20) continue;
                entity.m_7292_(new MobEffectInstance(effect, scaledDuration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_()));
            }
        }
    }

    private void extinguishFire(BlockPos pos) {
        Level level = this.m_9236_();
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13076_)) {
            level.m_7471_(pos, false);
        } else if (CampfireBlock.m_51319_((BlockState)state)) {
            level.m_5898_(null, 1009, pos, 0);
            CampfireBlock.m_152749_((Entity)this.m_19749_(), (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

