/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ManaArrowEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<String> SOURCE_TAG = SynchedEntityData.m_135353_(ManaArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public ManaArrowEntity(EntityType<? extends ManaArrowEntity> type, Level level) {
        super(type, level);
    }

    public ManaArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)EntityTypesPM.MANA_ARROW.get(), x, y, z, level);
    }

    public ManaArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)EntityTypesPM.MANA_ARROW.get(), shooter, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOURCE_TAG, (Object)"");
    }

    public void setSource(Source source) {
        this.f_19804_.m_135381_(SOURCE_TAG, (Object)source.getTag());
        if (source == Source.EARTH) {
            this.m_36735_(this.m_150123_() + 2);
        } else if (source == Source.SKY) {
            this.m_20242_(true);
        } else if (source == Source.INFERNAL) {
            this.m_20254_(100);
        } else if (source == Source.HALLOWED) {
            this.m_36781_(this.m_36789_() + 1.0);
        }
    }

    @Nullable
    public Source getSource() {
        return Source.getSource((String)this.f_19804_.m_135370_(SOURCE_TAG));
    }

    protected ItemStack m_7941_() {
        Item item = (Item)ManaArrowItem.SOURCE_MAPPING.get(this.getSource());
        return new ItemStack((ItemLike)(item == null ? Items.f_42412_ : item));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getSource() == Source.SKY && this.m_20068_() && this.m_20069_()) {
            this.m_20242_(false);
        }
        Level level = this.m_9236_();
        if (level.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        }
    }

    protected void makeParticle(int count) {
        Source source = this.getSource();
        if (source != null && count > 0) {
            Level level = this.m_9236_();
            RandomSource rng = level.f_46441_;
            int color = source.getColor();
            for (int index = 0; index < count; ++index) {
                double dx = (double)rng.m_188501_() * 0.035 * (double)(rng.m_188499_() ? 1 : -1);
                double dy = (double)rng.m_188501_() * 0.035 * (double)(rng.m_188499_() ? 1 : -1);
                double dz = (double)rng.m_188501_() * 0.035 * (double)(rng.m_188499_() ? 1 : -1);
                FxDispatcher.INSTANCE.manaArrowTrail(this.m_20185_(), this.m_20186_(), this.m_20189_(), dx, dy, dz, color);
            }
        }
    }

    protected void m_7761_(LivingEntity target) {
        super.m_7761_(target);
        Source source = this.getSource();
        if (source == Source.SEA) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50));
        } else if (source == Source.SUN) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 50));
            if (target.m_6336_() == MobType.f_21641_) {
                target.m_20254_(3);
            }
        } else if (source == Source.MOON) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50));
        } else if (source == Source.BLOOD) {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectsPM.BLEEDING.get(), 50));
        } else if (source == Source.VOID) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 50));
        } else if (source == Source.HALLOWED && target.m_6336_() == MobType.f_21641_) {
            target.m_20254_(3);
        }
    }

    protected float m_6882_() {
        Source source = this.getSource();
        return source == Source.SEA || source == Source.BLOOD ? 0.99f : super.m_6882_();
    }
}

