/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SpellMineEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> ARMED = SynchedEntityData.m_135353_(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(SpellMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final int ARMING_TIME = 60;
    protected SpellPackage spell;
    protected UUID casterId;
    protected ItemStack spellSource;
    protected int currentLife = 0;

    public SpellMineEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.spell = null;
    }

    public SpellMineEntity(Level world, Vec3 pos, LivingEntity caster, SpellPackage spell, @Nullable ItemStack spellSource, int durationMinutes) {
        super((EntityType)EntityTypesPM.SPELL_MINE.get(), world);
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.spell = spell;
        this.spellSource = spellSource.m_41777_();
        this.casterId = caster.m_20148_();
        this.setLifespan(1200 * durationMinutes);
        if (spell != null && spell.getPayload() != null) {
            this.setColor(spell.getPayload().getSource().getColor());
        }
    }

    @Nullable
    public SpellPackage getSpell() {
        return this.spell;
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    protected void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public boolean isArmed() {
        return (Boolean)this.m_20088_().m_135370_(ARMED);
    }

    protected void setArmed(boolean armed) {
        this.m_20088_().m_135381_(ARMED, (Object)armed);
    }

    protected int getLifespan() {
        return (Integer)this.m_20088_().m_135370_(LIFESPAN);
    }

    protected void setLifespan(int ticks) {
        this.m_20088_().m_135381_(LIFESPAN, (Object)ticks);
    }

    @Nullable
    public LivingEntity getCaster() {
        ServerLevel serverLevel;
        Level level;
        if (this.casterId != null && (level = this.m_9236_()) instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).m_8791_(this.casterId)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)level;
            return living;
        }
        return null;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(COLOR, (Object)0xFFFFFF);
        this.m_20088_().m_135372_(ARMED, (Object)Boolean.FALSE);
        this.m_20088_().m_135372_(LIFESPAN, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Caster", 10)) {
            this.casterId = compound.m_128342_("Caster");
        }
        this.spell = null;
        if (compound.m_128425_("Spell", 10)) {
            this.spell = new SpellPackage(compound.m_128469_("Spell"));
        }
        if (this.spell != null && !this.spell.isValid()) {
            this.spell = null;
        }
        if (this.spell != null && this.spell.getPayload() != null) {
            this.setColor(this.spell.getPayload().getSource().getColor());
        }
        this.spellSource = null;
        if (compound.m_128425_("SpellSource", 10)) {
            this.spellSource = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SpellSource"));
        }
        this.currentLife = compound.m_128451_("CurrentLife");
        this.setLifespan(compound.m_128451_("Lifespan"));
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.casterId != null) {
            compound.m_128362_("Caster", this.casterId);
        }
        if (this.spell != null) {
            compound.m_128365_("Spell", (Tag)this.spell.serializeNBT());
        }
        if (this.spellSource != null) {
            compound.m_128365_("SpellSource", (Tag)this.spellSource.serializeNBT());
        }
        compound.m_128405_("CurrentLife", this.currentLife);
        compound.m_128405_("Lifespan", this.getLifespan());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!(level.f_46443_ || this.spell != null && this.spell.isValid())) {
            this.m_146870_();
        }
        if (++this.currentLife > this.getLifespan()) {
            this.m_146870_();
        }
        if (!level.f_46443_ && this.m_6084_()) {
            if (!this.isArmed() && this.currentLife >= 60) {
                this.setArmed(true);
            }
            if (this.isArmed() && this.currentLife % 5 == 0) {
                AABB aabb = new AABB(this.m_20182_(), this.m_20182_()).m_82400_(1.0);
                List entityList = level.m_6249_((Entity)this, aabb, e -> e instanceof LivingEntity);
                boolean found = false;
                for (Entity entity : entityList) {
                    if (!entity.m_6084_()) continue;
                    if (this.spell != null && this.spell.getPayload() != null) {
                        this.spell.getPayload().playSounds(level, this.m_20183_());
                    }
                    if (this.getCaster() != null) {
                        SpellManager.executeSpellPayload(this.spell, (HitResult)new EntityHitResult(entity, this.m_20182_().m_82520_(0.0, 0.5, 0.0)), level, this.getCaster(), this.spellSource, false, this);
                    }
                    found = true;
                }
                if (found) {
                    this.m_146870_();
                }
            }
        }
    }
}

