/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.projectiles;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellTrailPacket;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class SpellProjectileEntity
extends AbstractArrow {
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SpellProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final SpellPackage spell;
    protected final ItemStack spellSource;

    public SpellProjectileEntity(EntityType<? extends AbstractArrow> type, Level worldIn) {
        super(type, worldIn);
        this.spell = null;
        this.spellSource = null;
    }

    public SpellProjectileEntity(Level world, LivingEntity thrower, SpellPackage spell, @Nullable ItemStack spellSource) {
        super((EntityType)EntityTypesPM.SPELL_PROJECTILE.get(), thrower, world);
        this.spell = spell;
        ItemStack itemStack = this.spellSource = spellSource == null ? null : spellSource.m_41777_();
        if (spell != null && spell.getPayload() != null) {
            this.setColor(spell.getPayload().getSource().getColor());
        }
    }

    public SpellProjectileEntity(Level world, double x, double y, double z, SpellPackage spell, @Nullable ItemStack spellSource) {
        super((EntityType)EntityTypesPM.SPELL_PROJECTILE.get(), x, y, z, world);
        this.spell = spell;
        ItemStack itemStack = this.spellSource = spellSource == null ? null : spellSource.m_41777_();
        if (spell != null && spell.getPayload() != null) {
            this.setColor(spell.getPayload().getSource().getColor());
        }
    }

    @Nullable
    public SpellPackage getSpell() {
        return this.spell;
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    protected void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.m_6084_() && this.f_19797_ % 2 == 0 && this.spell != null && this.spell.getPayload() != null) {
            PacketHandler.sendToAllAround(new SpellTrailPacket(this.m_20182_(), this.spell.getPayload().getSource().getColor()), (ResourceKey<Level>)level.m_46472_(), this.m_20183_(), 64.0);
        }
    }

    protected void m_6532_(HitResult result) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            if (result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_() instanceof SpellProjectileEntity) {
                return;
            }
            if (this.spell != null && this.spell.getPayload() != null) {
                LivingEntity shooter = this.m_19749_() instanceof LivingEntity ? (LivingEntity)this.m_19749_() : null;
                SpellManager.executeSpellPayload(this.spell, result, level, shooter, this.spellSource, true, (Entity)this);
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR, (Object)0xFFFFFF);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

