/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Fertilize<E extends TreefolkEntity>
extends Behavior<E> {
    private final float maxDistanceSqr;
    private final IntProvider cooldownRange;

    public Fertilize(float maxDistance, IntProvider cooldownRange) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)MemoryModuleTypesPM.FERTILIZED_RECENTLY.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.maxDistanceSqr = maxDistance * maxDistance;
        this.cooldownRange = cooldownRange;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        BonemealableBlock bonemealable;
        Brain<TreefolkEntity> brain = ((TreefolkEntity)((Object)pEntity)).m_6274_();
        BlockPos targetPos = brain.m_21952_((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get()).orElse(BlockPos.f_121853_);
        brain.m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(targetPos));
        BlockState state = pLevel.m_8055_(targetPos);
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)pLevel, targetPos, state, pLevel.f_46443_)) {
            if (bonemealable.m_214167_((Level)pLevel, pLevel.f_46441_, targetPos, state)) {
                bonemealable.m_214148_(pLevel, pLevel.f_46441_, targetPos, state);
                pLevel.m_46796_(1505, targetPos, 0);
            }
            brain.m_21882_((MemoryModuleType)MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), (Object)true, (long)this.cooldownRange.m_214085_(pLevel.f_46441_));
            brain.m_21936_((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get());
        }
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        Brain<TreefolkEntity> brain = ((TreefolkEntity)((Object)pOwner)).m_6274_();
        Vec3 targetCenter = Vec3.m_82512_((Vec3i)((Vec3i)brain.m_21952_((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get()).orElse(BlockPos.f_121853_)));
        return pOwner.m_20182_().m_82557_(targetCenter) <= (double)this.maxDistanceSqr;
    }
}

