/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StartFertilizing<E extends TreefolkEntity>
extends Behavior<E> {
    private final Predicate<E> canWorkPredicate;

    public StartFertilizing(Predicate<E> canWorkPredicate) {
        this(canWorkPredicate, 60);
    }

    public StartFertilizing(Predicate<E> canWorkPredicate, int duration) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)MemoryModuleTypesPM.FERTILIZED_RECENTLY.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get()), (Object)MemoryStatus.VALUE_ABSENT), duration);
        this.canWorkPredicate = canWorkPredicate;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        ((TreefolkEntity)((Object)pEntity)).m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()).ifPresent(list -> pEntity.m_6274_().m_21879_((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (Object)((BlockPos)list.get(0))));
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        return this.canWorkPredicate.test(pOwner) && !((TreefolkEntity)((Object)pOwner)).m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()).orElse(Collections.emptyList()).isEmpty();
    }
}

