/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.behavior.LongDistanceRangedAttack;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.Fertilize;
import com.verdantartifice.primalmagick.common.entities.treefolk.JoinDanceParty;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartAdmiringItemIfSeen;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartDancingSometimes;
import com.verdantartifice.primalmagick.common.entities.treefolk.StartFertilizing;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopAdmiringIfItemTooFarAway;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopAdmiringIfTiredOfTryingToReachItem;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopFertilizingIfTiredOfTryingToReachBlock;
import com.verdantartifice.primalmagick.common.entities.treefolk.StopHoldingItemIfNoLongerAdmiring;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import com.verdantartifice.primalmagick.common.loot.LootTablesPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreefolkAi {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final UniformInt ANGER_DURATION = TimeUtil.m_145020_((int)20, (int)39);
    private static final UniformInt DANCE_COOLDOWN = TimeUtil.m_145020_((int)300, (int)900);
    private static final UniformInt FERTILIZE_COOLDOWN = TimeUtil.m_145020_((int)5, (int)10);
    private static final int RECENTLY_DANCED_DURATION = 1200;
    private static final int DANCE_DURATION = 600;
    private static final int ADMIRE_DURATION = 120;
    private static final int MAX_DISTANCE_TO_WALK_TO_ITEM = 9;
    private static final int MAX_TIME_TO_WALK_TO_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_ADMIRE_WALKING_IF_CANT_REACH_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_FERTILIZING_IF_CANT_REACH_BLOCK = 200;
    private static final int BABY_FLEE_DURATION_AFTER_GETTING_HIT = 100;
    private static final int HIT_BY_PLAYER_MEMORY_TIMEOUT = 400;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final int RANGED_ATTACK_COOLDOWN = 30;
    private static final float MIN_RANGED_ATTACK_RANGE = 4.0f;
    private static final float MAX_RANGED_ATTACK_RANGE = 16.0f;
    private static final float MAX_FERTILIZE_RANGE = 2.0f;
    private static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    private static final int MAX_LOOK_DIST = 8;
    private static final int MAX_LOOK_DIST_FOR_PLAYER_HOLDING_LOVED_ITEM = 14;
    private static final int INTERACTION_RANGE = 8;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_WANTED_ITEM = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FLEEING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_WORKING = 0.6f;
    private static final float SWIM_CHANCE = 0.8f;

    public static Brain<?> makeBrain(TreefolkEntity entity, Brain<TreefolkEntity> brain) {
        TreefolkAi.initCoreActivity(brain);
        TreefolkAi.initIdleActivity(brain);
        TreefolkAi.initAdmireItemActivity(brain);
        TreefolkAi.initFightActivity(entity, brain);
        TreefolkAi.initAvoidActivity(brain);
        TreefolkAi.initCelebrateActivity(brain);
        TreefolkAi.initWorkActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<TreefolkEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), StopHoldingItemIfNoLongerAdmiring.create(), StartAdmiringItemIfSeen.create(120), JoinDanceParty.create(600, 1200), (Object)StopBeingAngryIfTargetDead.m_257993_()));
    }

    private static void initIdleActivity(Brain<TreefolkEntity> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)SetEntityLookTarget.m_257836_(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.m_257741_(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), new StartFertilizing<TreefolkEntity>(TreefolkEntity::isAdult), StartDancingSometimes.create(600, 1200, DANCE_COOLDOWN), (Object)TryFindLand.m_257647_((int)8, (float)1.0f), TreefolkAi.createIdleLookBehaviors(), TreefolkAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initAdmireItemActivity(Brain<TreefolkEntity> brain) {
        brain.m_21895_(Activity.f_37990_, 10, ImmutableList.of((Object)GoToWantedItem.m_257684_(TreefolkAi::isNotHoldingLovedItemInOffhand, (float)1.0f, (boolean)true, (int)9), new StopAdmiringIfItemTooFarAway(9), new StopAdmiringIfTiredOfTryingToReachItem(200, 200)), MemoryModuleType.f_26336_);
    }

    private static void initFightActivity(TreefolkEntity entity, Brain<TreefolkEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(living -> !TreefolkAi.isNearestValidAttackTarget(entity, living)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), new LongDistanceRangedAttack(30, 4.0f, 16.0f)), MemoryModuleType.f_26372_);
    }

    private static void initAvoidActivity(Brain<TreefolkEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.0f, (int)12, (boolean)true), TreefolkAi.createIdleLookBehaviors(), TreefolkAi.createIdleMovementBehaviors()), MemoryModuleType.f_26383_);
    }

    private static void initCelebrateActivity(Brain<TreefolkEntity> brain) {
        brain.m_21895_(Activity.f_37989_, 10, ImmutableList.of((Object)SetEntityLookTarget.m_257836_(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.m_257741_(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), (Object)BehaviorBuilder.m_257845_(t -> !t.isDancing(), (OneShot)GoToTargetLocation.m_257680_((MemoryModuleType)MemoryModuleType.f_26341_, (int)2, (float)1.0f)), (Object)BehaviorBuilder.m_257845_(TreefolkEntity::isDancing, (OneShot)GoToTargetLocation.m_257680_((MemoryModuleType)MemoryModuleType.f_26341_, (int)4, (float)0.6f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)EntityTypesPM.TREEFOLK.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257960_((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.f_26341_);
    }

    private static void initWorkActivity(Brain<TreefolkEntity> brain) {
        brain.m_21895_(Activity.f_37980_, 10, ImmutableList.of((Object)SetEntityLookTarget.m_257836_(TreefolkAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.m_257741_(TreefolkEntity::isAdult, TreefolkAi::findNearestValidAttackTarget), (Object)GoToTargetLocation.m_257680_((MemoryModuleType)((MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get()), (int)2, (float)0.6f), new StopFertilizingIfTiredOfTryingToReachBlock(200, 200), new Fertilize(2.0f, (IntProvider)FERTILIZE_COOLDOWN), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)EntityTypesPM.TREEFOLK.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257960_((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), (MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get());
    }

    private static RunOne<TreefolkEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)EntityTypesPM.TREEFOLK.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<TreefolkEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)((EntityType)EntityTypesPM.TREEFOLK.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.m_257845_(TreefolkAi::doesntSeeAnyPlayerHoldingLovedItem, (OneShot)SetWalkTargetFromLookTarget.m_257764_((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity entity) {
        return entity.m_6095_() == EntityType.f_20532_ && entity.m_21093_(TreefolkAi::isLovedItem);
    }

    public static boolean isLovedItem(ItemStack stack) {
        return stack.m_204117_(ItemTagsPM.TREEFOLK_LOVED);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(TreefolkEntity entity) {
        Optional attackablePlayerOptional;
        Brain<TreefolkEntity> brain = entity.m_6274_();
        Optional<LivingEntity> angryAtOptional = TreefolkAi.getAngerTarget(entity);
        if (angryAtOptional.isPresent() && Sensor.m_182377_((LivingEntity)entity, (LivingEntity)angryAtOptional.get())) {
            return angryAtOptional;
        }
        if (brain.m_21874_(MemoryModuleType.f_26335_) && (attackablePlayerOptional = brain.m_21952_(MemoryModuleType.f_148206_)).isPresent()) {
            return attackablePlayerOptional;
        }
        return Optional.empty();
    }

    private static boolean isNearestValidAttackTarget(TreefolkEntity entity, LivingEntity target) {
        return TreefolkAi.findNearestValidAttackTarget(entity).filter(e -> e == target).isPresent();
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26354_);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity entity) {
        return !TreefolkAi.seesPlayerHoldingLovedItem(entity);
    }

    public static boolean wantsToPickup(TreefolkEntity entity, ItemStack stack) {
        if (TreefolkAi.isAdmiringDisabled(entity) && entity.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            return false;
        }
        return TreefolkAi.isLovedItem(stack) && TreefolkAi.isNotHoldingLovedItemInOffhand(entity);
    }

    private static boolean isNotHoldingLovedItemInOffhand(TreefolkEntity entity) {
        return entity.m_21206_().m_41619_() || !TreefolkAi.isLovedItem(entity.m_21206_());
    }

    private static boolean isAdmiringDisabled(TreefolkEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26339_);
    }

    public static void stopHoldingOffHandItem(TreefolkEntity entity, boolean shouldBarter) {
        ItemStack stack = entity.m_21120_(InteractionHand.OFF_HAND);
        entity.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        if (entity.isAdult()) {
            if (shouldBarter && TreefolkAi.isLovedItem(stack)) {
                TreefolkAi.throwItems(entity, TreefolkAi.getBarterResponseItems(entity));
            } else {
                TreefolkAi.throwItems(entity, Collections.singletonList(stack));
            }
        } else if (!TreefolkAi.isLovedItem(stack)) {
            TreefolkAi.throwItems(entity, Collections.singletonList(stack));
        }
    }

    private static void throwItems(TreefolkEntity entity, List<ItemStack> stacks) {
        entity.m_6274_().m_21952_(MemoryModuleType.f_26368_).ifPresentOrElse(player -> TreefolkAi.throwItemsTowardPlayer(entity, player, stacks), () -> TreefolkAi.throwItemsTowardRandomPos(entity, stacks));
    }

    private static void throwItemsTowardPlayer(TreefolkEntity entity, Player player, List<ItemStack> stacks) {
        TreefolkAi.throwItemsTowardsPos(entity, stacks, player.m_20182_());
    }

    private static void throwItemsTowardRandomPos(TreefolkEntity entity, List<ItemStack> stacks) {
        TreefolkAi.throwItemsTowardsPos(entity, stacks, TreefolkAi.getRandomNearbyPos(entity));
    }

    private static void throwItemsTowardsPos(TreefolkEntity entity, List<ItemStack> stacks, Vec3 position) {
        if (!stacks.isEmpty()) {
            entity.m_6674_(InteractionHand.OFF_HAND);
            for (ItemStack stack : stacks) {
                BehaviorUtils.m_22613_((LivingEntity)entity, (ItemStack)stack, (Vec3)position.m_82520_(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vec3 getRandomNearbyPos(TreefolkEntity entity) {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)entity, (int)4, (int)2);
        return vec3 == null ? entity.m_20182_() : vec3;
    }

    private static List<ItemStack> getBarterResponseItems(TreefolkEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(LootTablesPM.TREEFOLK_BARTERING);
            return table.m_287195_(new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81417_));
        }
        return Collections.emptyList();
    }

    public static void pickUpItem(TreefolkEntity entity, ItemEntity itemEntity) {
        TreefolkAi.stopWalking(entity);
        entity.m_7938_((Entity)itemEntity, 1);
        ItemStack stack = TreefolkAi.removeOneItemFromItemEntity(itemEntity);
        if (TreefolkAi.isLovedItem(stack)) {
            entity.m_6274_().m_21936_(MemoryModuleType.f_26337_);
            TreefolkAi.holdInOffhand(entity, stack);
            TreefolkAi.admireLovedItem(entity);
        } else {
            TreefolkAi.throwItemsTowardRandomPos(entity, Collections.singletonList(stack));
        }
    }

    private static void stopWalking(TreefolkEntity entity) {
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        entity.m_21573_().m_26573_();
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        ItemStack splitStack = stack.m_41620_(1);
        if (stack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(stack);
        }
        return splitStack;
    }

    private static void holdInOffhand(TreefolkEntity entity, ItemStack stack) {
        if (TreefolkAi.isHoldingItemInOffHand(entity)) {
            entity.m_19983_(entity.m_21120_(InteractionHand.OFF_HAND));
        }
        entity.holdInOffHand(stack);
    }

    private static boolean isHoldingItemInOffHand(TreefolkEntity entity) {
        return !entity.m_21206_().m_41619_();
    }

    private static void admireLovedItem(TreefolkEntity entity) {
        entity.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, 120L);
    }

    public static void updateActivity(TreefolkEntity entity) {
        Brain<TreefolkEntity> brain = entity.m_6274_();
        Activity activityBefore = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37990_, (Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37989_, (Object)Activity.f_37980_, (Object)Activity.f_37979_));
        Activity activityAfter = brain.m_21968_().orElse(null);
        if (activityBefore != activityAfter) {
            // empty if block
        }
        entity.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
        if (!brain.m_21874_(MemoryModuleType.f_26341_)) {
            brain.m_21936_(MemoryModuleType.f_26342_);
        }
        entity.setDancing(brain.m_21874_(MemoryModuleType.f_26342_));
    }

    public static void wasHurtBy(TreefolkEntity entity, LivingEntity target) {
        if (!(target instanceof TreefolkEntity)) {
            if (TreefolkAi.isHoldingItemInOffHand(entity)) {
                TreefolkAi.stopHoldingOffHandItem(entity, false);
            }
            Brain<TreefolkEntity> brain = entity.m_6274_();
            brain.m_21936_(MemoryModuleType.f_26341_);
            brain.m_21936_(MemoryModuleType.f_26342_);
            brain.m_21936_(MemoryModuleType.f_26336_);
            if (target instanceof Player) {
                brain.m_21882_(MemoryModuleType.f_26339_, (Object)true, 400L);
            }
            TreefolkAi.getAvoidTarget(entity).ifPresent(avoid -> {
                if (avoid.m_6095_() != target.m_6095_()) {
                    brain.m_21936_(MemoryModuleType.f_26383_);
                }
            });
            if (entity.m_6162_()) {
                brain.m_21882_(MemoryModuleType.f_26383_, (Object)target, 100L);
                if (Sensor.m_182377_((LivingEntity)entity, (LivingEntity)target)) {
                    TreefolkAi.broadcastAngerTarget(entity, target);
                }
            } else {
                TreefolkAi.maybeRetaliate(entity, target);
            }
        }
    }

    private static Optional<LivingEntity> getAvoidTarget(TreefolkEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26383_) ? entity.m_6274_().m_21952_(MemoryModuleType.f_26383_) : Optional.empty();
    }

    private static void maybeRetaliate(TreefolkEntity entity, LivingEntity target) {
        if (!entity.m_6274_().m_21954_(Activity.f_37991_) && Sensor.m_182377_((LivingEntity)entity, (LivingEntity)target) && !BehaviorUtils.m_22598_((LivingEntity)entity, (LivingEntity)target, (double)4.0)) {
            if (target.m_6095_() == EntityType.f_20532_ && entity.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                TreefolkAi.setAngerTargetToNearestTargetablePlayerIfFound(entity, target);
                TreefolkAi.broadcastUniversalAnger(entity);
            } else {
                TreefolkAi.setAngerTarget(entity, target);
                TreefolkAi.broadcastAngerTarget(entity, target);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(TreefolkEntity entity, LivingEntity currentTarget) {
        TreefolkAi.getNearestVisibleTargetablePlayer(entity).ifPresentOrElse(player -> TreefolkAi.setAngerTarget(entity, (LivingEntity)player), () -> TreefolkAi.setAngerTarget(entity, currentTarget));
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(TreefolkEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_148206_) ? entity.m_6274_().m_21952_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    private static void setAngerTarget(TreefolkEntity entity, LivingEntity target) {
        Level level = entity.m_9236_();
        if (Sensor.m_182377_((LivingEntity)entity, (LivingEntity)target)) {
            int angerDuration = ANGER_DURATION.m_214085_(level.f_46441_);
            entity.m_6274_().m_21936_(MemoryModuleType.f_26326_);
            entity.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), (long)angerDuration);
            if (target.m_6095_() == EntityType.f_20532_ && level.m_46469_().m_46207_(GameRules.f_46127_)) {
                entity.m_6274_().m_21882_(MemoryModuleType.f_26335_, (Object)true, (long)angerDuration);
            }
        }
    }

    private static void broadcastUniversalAnger(TreefolkEntity entity) {
        TreefolkAi.getNearbyAdultTreefolk(entity).forEach(t -> TreefolkAi.getNearestVisibleTargetablePlayer(t).ifPresent(p -> TreefolkAi.setAngerTarget(t, (LivingEntity)p)));
    }

    private static void broadcastAngerTarget(TreefolkEntity entity, LivingEntity target) {
        TreefolkAi.getNearbyAdultTreefolk(entity).forEach(t -> TreefolkAi.setAngerTargetIfCloserThanCurrent(t, target));
    }

    private static List<TreefolkEntity> getNearbyTreefolk(TreefolkEntity entity) {
        return (List)entity.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypesPM.NEARBY_TREEFOLK.get()).orElse(ImmutableList.of());
    }

    private static List<TreefolkEntity> getNearbyAdultTreefolk(TreefolkEntity entity) {
        return (List)entity.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get()).orElse(ImmutableList.of());
    }

    private static void setAngerTargetIfCloserThanCurrent(TreefolkEntity entity, LivingEntity currentTarget) {
        Optional<LivingEntity> livingOpt = TreefolkAi.getAngerTarget(entity);
        LivingEntity nearestTarget = BehaviorUtils.m_22625_((LivingEntity)entity, livingOpt, (LivingEntity)currentTarget);
        if (!livingOpt.isPresent() || livingOpt.get() != nearestTarget) {
            TreefolkAi.setAngerTarget(entity, nearestTarget);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(TreefolkEntity entity) {
        return BehaviorUtils.m_22610_((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26334_);
    }

    public static void startDanceParty(TreefolkEntity entity, int duration, int cooldown) {
        entity.m_6274_().m_21882_(MemoryModuleType.f_26342_, (Object)true, (long)duration);
        entity.m_6274_().m_21882_(MemoryModuleType.f_26341_, (Object)entity.m_20183_(), (long)duration);
        entity.m_6274_().m_21882_((MemoryModuleType)MemoryModuleTypesPM.DANCED_RECENTLY.get(), (Object)true, (long)cooldown);
        TreefolkAi.broadcastCelebrateLocation(entity, duration);
    }

    public static void broadcastCelebrateLocation(TreefolkEntity entity, int danceDuration) {
        entity.m_6274_().m_21952_(MemoryModuleType.f_26341_).ifPresent(pos -> TreefolkAi.getNearbyTreefolk(entity).forEach(t -> t.m_6274_().m_21882_(MemoryModuleType.f_26341_, pos, (long)danceDuration)));
    }

    public static InteractionResult mobInteract(TreefolkEntity entity, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (TreefolkAi.isLovedItem(stack)) {
            ItemStack splitStack = stack.m_41620_(1);
            TreefolkAi.holdInOffhand(entity, splitStack);
            TreefolkAi.admireLovedItem(entity);
            TreefolkAi.stopWalking(entity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAdmire(TreefolkEntity entity, ItemStack stack) {
        return !TreefolkAi.isAdmiringDisabled(entity) && !TreefolkAi.isAdmiringItem(entity) && entity.isAdult() && TreefolkAi.isLovedItem(stack);
    }

    private static boolean isAdmiringItem(TreefolkEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26336_);
    }
}

