/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.treefolk;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.ai.sensing.SensorTypesPM;
import com.verdantartifice.primalmagick.common.entities.projectiles.AppleEntity;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkAi;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkArmPose;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreefolkEntity
extends AgeableMob
implements RangedAttackMob {
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final String DREADED_NAME = "Verdus";
    protected static final ImmutableList<SensorType<? extends Sensor<? super TreefolkEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26814_, (Object)((SensorType)SensorTypesPM.TREEFOLK_SPECIFIC_SENSOR.get()), (Object)((SensorType)SensorTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26374_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26335_, MemoryModuleType.f_26336_, MemoryModuleType.f_26337_, MemoryModuleType.f_26339_, MemoryModuleType.f_26338_, MemoryModuleType.f_26341_, MemoryModuleType.f_26342_, MemoryModuleType.f_26354_, (MemoryModuleType)MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get(), (MemoryModuleType)MemoryModuleTypesPM.NEAREST_VISIBLE_ADULT_TREEFOLK.get(), (MemoryModuleType)MemoryModuleTypesPM.DANCED_RECENTLY.get(), (MemoryModuleType)MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get(), (MemoryModuleType)MemoryModuleTypesPM.FERTILIZE_LOCATION.get(), (MemoryModuleType)MemoryModuleTypesPM.FERTILIZED_RECENTLY.get(), (MemoryModuleType)MemoryModuleTypesPM.TIME_TRYING_TO_REACH_FERTILIZE_BLOCK.get(), (MemoryModuleType)MemoryModuleTypesPM.DISABLE_WALK_TO_FERTILIZE_BLOCK.get(), (MemoryModuleType)MemoryModuleTypesPM.NEARBY_TREEFOLK.get(), MemoryModuleType.f_26383_});
    private static final EntityDataAccessor<Boolean> DATA_IS_DANCING = SynchedEntityData.m_135353_(TreefolkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public TreefolkEntity(EntityType<? extends TreefolkEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21553_(true);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 5.0);
    }

    public static boolean canSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return Mob.m_217057_(typeIn, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_DANCING, (Object)false);
    }

    public boolean isAngry() {
        return this.m_5912_();
    }

    public boolean isAdult() {
        return !this.m_6162_();
    }

    protected Brain.Provider<TreefolkEntity> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        return TreefolkAi.makeBrain(this, (Brain<TreefolkEntity>)this.m_5490_().m_22073_(pDynamic));
    }

    public Brain<TreefolkEntity> m_6274_() {
        return super.m_6274_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SoundsPM.TREEFOLK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsPM.TREEFOLK_DEATH.get();
    }

    protected void m_8024_() {
        Level level = this.m_9236_();
        level.m_46473_().m_6180_("treefolkBrain");
        this.m_6274_().m_21865_((ServerLevel)level, (LivingEntity)this);
        level.m_46473_().m_7238_();
        TreefolkAi.updateActivity(this);
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_8077_() && DREADED_NAME.equals(this.m_7770_().getString())) {
            this.m_20254_(8);
        }
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        Level level = this.m_9236_();
        if (!level.f_46443_ && DREADED_NAME.equals(name.getString())) {
            List<Player> nearby = EntityUtils.getEntitiesInRange(level, this.m_20182_(), null, Player.class, 6.0);
            for (Player player : nearby) {
                StatsManager.incrementValue(player, StatsPM.TREANTS_NAMED);
            }
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        Level level = this.m_9236_();
        AppleEntity missile = new AppleEntity(level, (LivingEntity)this);
        missile.m_37446_(new ItemStack((ItemLike)Items.f_42410_));
        double d0 = target.m_20188_() - (double)1.1f;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - missile.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        float f = (float)Math.sqrt(d1 * d1 + d3 * d3) * 0.2f;
        missile.m_6686_(d1, d2 + (double)f, d3, 1.6f, 14 - level.m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_12473_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        level.m_7967_((Entity)missile);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        Level level = this.m_9236_();
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42409_)) {
            level.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!level.f_46443_) {
                this.m_20254_(10);
                this.m_6703_((LivingEntity)player);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            return TreefolkAi.mobInteract(this, player, hand);
        }
        boolean flag = TreefolkAi.canAdmire(this, stack) && this.getArmPose() != TreefolkArmPose.ADMIRING_ITEM;
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean m_7243_(ItemStack pStack) {
        return ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_21531_() && TreefolkAi.wantsToPickup(this, pStack);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        this.m_21053_(pItemEntity);
        TreefolkAi.pickUpItem(this, pItemEntity);
    }

    public void holdInOffHand(ItemStack stack) {
        if (TreefolkAi.isLovedItem(stack)) {
            this.m_8061_(EquipmentSlot.OFFHAND, stack);
            this.m_21508_(EquipmentSlot.OFFHAND);
        } else {
            this.m_21468_(EquipmentSlot.OFFHAND, stack);
        }
    }

    public TreefolkArmPose getArmPose() {
        if (this.isDancing()) {
            return TreefolkArmPose.DANCING;
        }
        if (TreefolkAi.isLovedItem(this.m_21206_())) {
            return TreefolkArmPose.ADMIRING_ITEM;
        }
        return TreefolkArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_DANCING);
    }

    public void setDancing(boolean pDancing) {
        this.f_19804_.m_135381_(DATA_IS_DANCING, (Object)pDancing);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        boolean flag = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            TreefolkAi.wasHurtBy(this, livingSource);
        }
        return flag;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public LivingEntity m_5448_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)EntityTypesPM.TREEFOLK.get()).m_20615_((Level)pLevel);
    }
}

