/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.events.PlayerEvents;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.misc.InteractionRecord;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenEnchantedBookScreenPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenGrimoireScreenPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenStaticBookScreenPacket;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalmagick")
public class BlockEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level world;
        Player player = event.getPlayer();
        Level level = world = event.getLevel() instanceof Level ? (Level)event.getLevel() : null;
        if (!(event.isCanceled() || world == null || world.f_46443_ || player.m_36341_() || BlockBreaker.hasBreakerQueued(world, event.getPos()))) {
            BlockEvents.triggerReverberation(world, event.getPos(), event.getState(), player, player.m_21205_());
            BlockEvents.triggerDisintegration(world, event.getPos(), event.getState(), player, player.m_21205_());
        }
    }

    private static void triggerReverberation(Level world, BlockPos pos, BlockState state, Player player, ItemStack tool) {
        Direction dir;
        int level = tool.getEnchantmentLevel((Enchantment)EnchantmentsPM.REVERBERATION.get());
        if (level <= 0) {
            return;
        }
        InteractionRecord interact = PlayerEvents.LAST_BLOCK_LEFT_CLICK.get(player.m_20148_());
        if (interact == null) {
            Vec3 endPos;
            Vec3 startPos = player.m_20299_(1.0f);
            BlockHitResult rayTraceResult = world.m_45547_(new ClipContext(startPos, endPos = startPos.m_82549_(player.m_20252_(1.0f).m_82490_(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            dir = rayTraceResult.m_82434_();
        } else {
            dir = interact.getFace();
        }
        float durability = (float)Math.sqrt(100.0f * state.m_60800_((BlockGetter)world, pos));
        int xLimit = level * (dir.m_122429_() == 0 ? 1 : 0);
        int yLimit = level * (dir.m_122430_() == 0 ? 1 : 0);
        int zLimit = level * (dir.m_122431_() == 0 ? 1 : 0);
        for (int dx = -xLimit; dx <= xLimit; ++dx) {
            for (int dy = -yLimit; dy <= yLimit; ++dy) {
                for (int dz = -zLimit; dz <= zLimit; ++dz) {
                    BlockPos targetPos = new BlockPos(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz);
                    if (targetPos.equals((Object)pos)) continue;
                    BlockState targetState = world.m_8055_(targetPos);
                    float targetDurability = (float)Math.sqrt(100.0f * targetState.m_60800_((BlockGetter)world, pos));
                    float newDurability = Math.max(0.0f, targetDurability - durability);
                    BlockBreaker breaker = new BlockBreaker.Builder().target(targetPos, targetState).durability(newDurability, targetDurability).player(player).tool(tool).oneShot().skipEvent().build();
                    BlockBreaker.schedule(world, targetPos.m_123333_((Vec3i)pos), breaker);
                }
            }
        }
    }

    private static void triggerDisintegration(Level world, BlockPos pos, BlockState state, Player player, ItemStack tool) {
        int level = tool.getEnchantmentLevel((Enchantment)EnchantmentsPM.DISINTEGRATION.get());
        if (level <= 0) {
            return;
        }
        float durability = (float)Math.sqrt(100.0f * state.m_60800_((BlockGetter)world, pos));
        int breakerCount = 10 * level - 1;
        HashSet<BlockPos> examinedPositions = new HashSet<BlockPos>();
        LinkedList<BlockPos> processingQueue = new LinkedList<BlockPos>();
        examinedPositions.add(pos);
        for (Direction dir : Direction.values()) {
            BlockPos setupPos = pos.m_121945_(dir);
            examinedPositions.add(setupPos);
            processingQueue.offer(setupPos);
        }
        while (!processingQueue.isEmpty() && breakerCount > 0) {
            BlockPos curPos = (BlockPos)processingQueue.poll();
            BlockState curState = world.m_8055_(curPos);
            if (!curState.m_60734_().equals(state.m_60734_())) continue;
            --breakerCount;
            BlockBreaker breaker = new BlockBreaker.Builder().target(curPos, curState).durability(0.0f, durability).player(player).tool(tool).oneShot().skipEvent().build();
            BlockBreaker.schedule(world, curPos.m_123333_((Vec3i)pos), breaker);
            for (Direction dir : Direction.values()) {
                BlockPos nextPos = curPos.m_121945_(dir);
                if (examinedPositions.contains(nextPos)) continue;
                examinedPositions.add(nextPos);
                processingQueue.offer(nextPos);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreakLowest(BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && event.getState().m_60800_((BlockGetter)event.getLevel(), event.getPos()) >= 2.0f && event.getPlayer().m_21205_().m_41619_()) {
            StatsManager.incrementValue(event.getPlayer(), StatsPM.BLOCKS_BROKEN_BAREHANDED);
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = InteractionResult.PASS;
        BlockPos pos = event.getHitVec().m_82425_();
        BlockEntity tileEntity = event.getLevel().m_7702_(pos);
        if (tileEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lecternEntity = (LecternBlockEntity)tileEntity;
            result = BlockEvents.handleLecternRightClick(lecternEntity, event.getEntity(), event.getHand());
        }
        if (result.m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    private static InteractionResult handleLecternRightClick(LecternBlockEntity lecternEntity, Player player, InteractionHand hand) {
        Level level = lecternEntity.m_58904_();
        if (((Boolean)lecternEntity.m_58900_().m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
            if (player.m_36341_()) {
                ItemStack bookStack = lecternEntity.m_59566_();
                lecternEntity.m_59536_(ItemStack.f_41583_);
                LecternBlock.m_269306_((Entity)player, (Level)level, (BlockPos)lecternEntity.m_58899_(), (BlockState)lecternEntity.m_58900_(), (boolean)false);
                if (!player.m_150109_().m_36054_(bookStack)) {
                    player.m_36176_(bookStack, false);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.m_59566_().m_150930_((Item)ItemsPM.GRIMOIRE.get())) {
                if (!level.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    StatsManager.incrementValue(player, StatsPM.GRIMOIRE_READ);
                    PacketHandler.sendToPlayer(new OpenGrimoireScreenPacket(), serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.m_59566_().m_150930_((Item)ItemsPM.STATIC_BOOK.get())) {
                if (!level.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketHandler.sendToPlayer(new OpenStaticBookScreenPacket(lecternEntity.m_59566_(), BookType.BOOK.getBackgroundTexture()), serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            if (lecternEntity.m_59566_().m_150930_(Items.f_42690_)) {
                if (!level.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EnchantmentHelper.m_44831_((ItemStack)lecternEntity.m_59566_()).entrySet().stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue())).findFirst().ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Enchantment)entry.getKey()), serverPlayer));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            ItemStack handStack = player.m_21120_(hand);
            if (handStack.m_204117_(ItemTags.f_13162_) && LecternBlock.m_269125_((Entity)player, (Level)level, (BlockPos)lecternEntity.m_58899_(), (BlockState)lecternEntity.m_58900_(), (ItemStack)handStack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

